/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.lock.intercept;

import com.livk.commons.aop.AnnotationAbstractPointcutTypeAdvisor;
import com.livk.commons.expression.ExpressionResolver;
import com.livk.commons.expression.spring.SpringExpressionResolver;
import com.livk.context.lock.DistributedLock;
import com.livk.context.lock.LockScope;
import com.livk.context.lock.annotation.OnLock;
import com.livk.context.lock.exception.LockException;
import com.livk.context.lock.exception.UnSupportLockException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.Assert;

public class LockInterceptor
extends AnnotationAbstractPointcutTypeAdvisor<OnLock> {
    private final ObjectProvider<DistributedLock> distributedLockProvider;
    private final ExpressionResolver resolver = new SpringExpressionResolver();

    protected Object invoke(MethodInvocation invocation, OnLock onLock) throws Throwable {
        Assert.notNull((Object)onLock, (String)"lock is null");
        LockScope scope = onLock.scope();
        DistributedLock distributedLock = this.distributedLockProvider.orderedStream().filter(lock -> lock.scope().equals((Object)scope)).findFirst().orElseThrow(() -> new UnSupportLockException("\u7f3a\u5c11scope\uff1a" + String.valueOf((Object)scope) + "\u7684\u9501\u5b9e\u73b0"));
        boolean async = !LockScope.STANDALONE_LOCK.equals((Object)scope) && onLock.async();
        String key = this.resolver.evaluate(onLock.key(), invocation.getMethod(), invocation.getArguments());
        boolean isLock = distributedLock.tryLock(onLock.type(), key, onLock.leaseTime(), onLock.waitTime(), async);
        try {
            if (isLock) {
                Object object = invocation.proceed();
                return object;
            }
            throw new LockException("\u83b7\u53d6\u9501\u5931\u8d25!");
        }
        finally {
            if (isLock) {
                distributedLock.unlock();
            }
        }
    }

    public LockInterceptor(ObjectProvider<DistributedLock> distributedLockProvider) {
        this.distributedLockProvider = distributedLockProvider;
    }
}

