/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.lock.support;

import com.livk.commons.util.Pair;
import com.livk.context.lock.DistributedLock;
import com.livk.context.lock.LockType;
import com.livk.context.lock.exception.LockException;
import com.livk.context.lock.exception.UnSupportLockException;

public abstract class AbstractLockSupport<T>
implements DistributedLock {
    protected final ThreadLocal<Pair<String, T>> threadLocal = new InheritableThreadLocal<Pair<String, T>>();

    @Override
    public boolean tryLock(LockType type, String key, long leaseTime, long waitTime, boolean async) {
        T lock = this.getLock(type, key);
        try {
            boolean isLocked;
            boolean bl = isLocked = this.supportAsync() && async ? this.tryLockAsync(lock, leaseTime, waitTime) : this.tryLock(lock, waitTime, leaseTime);
            if (isLocked) {
                this.threadLocal.set(Pair.of((Object)key, lock));
            }
            return isLocked;
        }
        catch (Exception e) {
            this.threadLocal.remove();
            throw new LockException(e);
        }
    }

    @Override
    public void lock(LockType type, String key, boolean async) {
        T lock = this.getLock(type, key);
        try {
            if (this.supportAsync() && async) {
                this.lockAsync(lock);
            } else {
                this.lock(lock);
            }
            this.threadLocal.set(Pair.of((Object)key, lock));
        }
        catch (Exception e) {
            this.threadLocal.remove();
            throw new LockException(e);
        }
    }

    @Override
    public void unlock() {
        Pair<String, T> pair = this.threadLocal.get();
        if (pair != null) {
            String key = (String)pair.key();
            Object lock = pair.value();
            if (this.isLocked(lock) && this.unlock(key, lock)) {
                this.threadLocal.remove();
            }
        }
    }

    protected abstract T getLock(LockType var1, String var2);

    protected abstract boolean unlock(String var1, T var2);

    protected boolean tryLockAsync(T lock, long leaseTime, long waitTime) throws Exception {
        throw new UnSupportLockException("Async lock of " + this.getClass().getSimpleName() + " isn't support");
    }

    protected abstract boolean tryLock(T var1, long var2, long var4) throws Exception;

    protected void lockAsync(T lock) throws Exception {
        throw new UnSupportLockException("Async lock of " + this.getClass().getSimpleName() + " isn't support");
    }

    protected abstract void lock(T var1) throws Exception;

    protected abstract boolean isLocked(T var1);

    protected boolean supportAsync() {
        return false;
    }
}

