/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.lock.support;

import com.livk.context.lock.LockScope;
import com.livk.context.lock.LockType;
import com.livk.context.lock.exception.LockException;
import com.livk.context.lock.support.AbstractLockSupport;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;

public class CuratorLock
extends AbstractLockSupport<InterProcessLock> {
    private final CuratorFramework curatorFramework;

    @Override
    protected InterProcessLock getLock(LockType type, String key) {
        if (!key.startsWith("/")) {
            key = "/".concat(key);
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case LockType.LOCK, LockType.FAIR -> new InterProcessMutex(this.curatorFramework, key);
            case LockType.READ -> new InterProcessReadWriteLock(this.curatorFramework, key).readLock();
            case LockType.WRITE -> new InterProcessReadWriteLock(this.curatorFramework, key).writeLock();
        };
    }

    @Override
    protected boolean unlock(String key, InterProcessLock lock) {
        try {
            lock.release();
            return !this.isLocked(lock);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    @Override
    protected boolean tryLock(InterProcessLock lock, long leaseTime, long waitTime) throws Exception {
        return lock.acquire(waitTime, TimeUnit.SECONDS);
    }

    @Override
    protected void lock(InterProcessLock lock) throws Exception {
        lock.acquire();
    }

    @Override
    protected boolean isLocked(InterProcessLock lock) {
        return lock.isAcquiredInThisProcess();
    }

    @Override
    public LockScope scope() {
        return LockScope.DISTRIBUTED_LOCK;
    }

    public CuratorLock(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }
}

