/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.lock.support;

import com.livk.context.lock.LockScope;
import com.livk.context.lock.LockType;
import com.livk.context.lock.support.AbstractLockSupport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LocalLock
extends AbstractLockSupport<Lock> {
    private static final Map<String, Lock> CACHE_LOCK = new ConcurrentHashMap<String, Lock>();

    @Override
    protected Lock getLock(LockType type, String key) {
        return CACHE_LOCK.computeIfAbsent(key, s -> switch (type) {
            default -> throw new MatchException(null, null);
            case LockType.LOCK -> new ReentrantLock();
            case LockType.FAIR -> new ReentrantLock(true);
            case LockType.READ -> new ReentrantReadWriteLock().readLock();
            case LockType.WRITE -> new ReentrantReadWriteLock().writeLock();
        });
    }

    @Override
    protected boolean tryLock(Lock lock, long leaseTime, long waitTime) throws Exception {
        return lock.tryLock(waitTime, TimeUnit.SECONDS);
    }

    @Override
    protected void lock(Lock lock) {
        lock.lock();
    }

    @Override
    protected boolean unlock(String key, Lock lock) {
        lock.unlock();
        return !this.isLocked(lock);
    }

    @Override
    protected boolean isLocked(Lock lock) {
        if (lock instanceof ReentrantLock) {
            ReentrantLock reentrantLock = (ReentrantLock)lock;
            return reentrantLock.isLocked() && reentrantLock.isHeldByCurrentThread();
        }
        if (lock instanceof ReentrantReadWriteLock.WriteLock) {
            ReentrantReadWriteLock.WriteLock writeLock = (ReentrantReadWriteLock.WriteLock)lock;
            return writeLock.getHoldCount() != 0 && writeLock.isHeldByCurrentThread();
        }
        return false;
    }

    @Override
    public LockScope scope() {
        return LockScope.STANDALONE_LOCK;
    }
}

