/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.lock.support;

import com.livk.context.lock.LockScope;
import com.livk.context.lock.LockType;
import com.livk.context.lock.support.AbstractLockSupport;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedissonLock
extends AbstractLockSupport<RLock> {
    private final RedissonClient redissonClient;

    @Override
    protected RLock getLock(LockType type, String key) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case LockType.LOCK -> this.redissonClient.getLock(key);
            case LockType.FAIR -> this.redissonClient.getFairLock(key);
            case LockType.READ -> this.redissonClient.getReadWriteLock(key).readLock();
            case LockType.WRITE -> this.redissonClient.getReadWriteLock(key).writeLock();
        };
    }

    @Override
    protected boolean unlock(String key, RLock lock) {
        lock.unlock();
        return !this.isLocked(lock);
    }

    @Override
    protected boolean tryLockAsync(RLock lock, long leaseTime, long waitTime) throws Exception {
        return (Boolean)lock.tryLockAsync(waitTime, leaseTime, TimeUnit.SECONDS).get();
    }

    @Override
    protected boolean tryLock(RLock lock, long leaseTime, long waitTime) throws Exception {
        return lock.tryLock(waitTime, leaseTime, TimeUnit.SECONDS);
    }

    @Override
    protected void lockAsync(RLock lock) throws Exception {
        lock.lockAsync().get();
    }

    @Override
    protected void lock(RLock lock) {
        lock.lock();
    }

    @Override
    protected boolean isLocked(RLock lock) {
        return lock.isLocked() && lock.isHeldByCurrentThread();
    }

    @Override
    public LockScope scope() {
        return LockScope.DISTRIBUTED_LOCK;
    }

    @Override
    protected boolean supportAsync() {
        return true;
    }

    public RedissonLock(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

