/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.mapstruct;

import com.livk.context.mapstruct.PrioritizedMapstructLocator;
import com.livk.context.mapstruct.converter.Converter;
import com.livk.context.mapstruct.converter.ConverterPair;
import com.livk.context.mapstruct.converter.MapstructRegistry;
import com.livk.context.mapstruct.converter.MapstructService;
import com.livk.context.mapstruct.exception.ConverterNotFoundException;
import com.livk.context.mapstruct.repository.MapstructLocator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractMapstructService
implements MapstructService,
MapstructRegistry,
ApplicationContextAware {
    private MapstructLocator mapstructLocator;

    @Override
    public <S, T> T convert(S source, Class<T> targetType) {
        Class<?> sourceType = source.getClass();
        Converter<?, T> sourceConverter = this.getConverter(sourceType, targetType);
        if (sourceConverter != null) {
            return sourceConverter.getTarget(source);
        }
        Converter<S, ?> targetConverter = this.getConverter(targetType, sourceType);
        if (targetConverter != null) {
            return targetConverter.getSource(source);
        }
        throw new ConverterNotFoundException(String.valueOf(source) + " to class " + String.valueOf(targetType) + " not found converter");
    }

    private <S, T> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        ConverterPair converterPair = ConverterPair.of(sourceType, targetType);
        return this.mapstructLocator.get(converterPair);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ObjectProvider mapstructLocators = applicationContext.getBeanProvider(MapstructLocator.class);
        this.mapstructLocator = new PrioritizedMapstructLocator(this, (ObjectProvider<MapstructLocator>)mapstructLocators);
    }
}

