/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.mapstruct;

import com.livk.context.mapstruct.converter.Converter;
import com.livk.context.mapstruct.converter.ConverterPair;
import com.livk.context.mapstruct.converter.MapstructRegistry;
import com.livk.context.mapstruct.repository.ConverterRepository;
import com.livk.context.mapstruct.repository.MapstructLocator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;

class PrioritizedMapstructLocator
implements MapstructLocator {
    private final MapstructRegistry mapstructRegistry;
    private final List<MapstructLocator> mapstructLocators = new ArrayList<MapstructLocator>();
    private ConverterRepository converterRepository;

    public PrioritizedMapstructLocator(MapstructRegistry mapstructRegistry, ObjectProvider<MapstructLocator> mapstructLocatorObjectProvider) {
        this.mapstructRegistry = mapstructRegistry;
        for (MapstructLocator mapstructLocator : mapstructLocatorObjectProvider.orderedStream().toList()) {
            if (mapstructLocator instanceof ConverterRepository) {
                ConverterRepository repository;
                this.converterRepository = repository = (ConverterRepository)mapstructLocator;
                continue;
            }
            this.mapstructLocators.add(mapstructLocator);
        }
    }

    @Override
    public <S, T> Converter<S, T> get(ConverterPair converterPair) {
        Converter converter = this.converterRepository.get(converterPair);
        if (converter == null) {
            for (MapstructLocator mapstructLocator : this.mapstructLocators) {
                converter = mapstructLocator.get(converterPair);
                if (converter == null) continue;
                return this.mapstructRegistry.addConverter(converterPair, converter);
            }
        }
        return converter;
    }
}

