/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.mapstruct.converter;

import com.livk.commons.util.ObjectUtils;
import com.livk.context.mapstruct.converter.Converter;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.Assert;

public class ConverterPair {
    private final Class<?> sourceType;
    private final Class<?> targetType;

    private ConverterPair(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType, (String)"Source type must not be null");
        Assert.notNull(targetType, (String)"Target type must not be null");
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public static ConverterPair of(Class<?> sourceType, Class<?> targetType) {
        return new ConverterPair(sourceType, targetType);
    }

    public static ConverterPair of(Converter<?, ?> converter) {
        Object[] types = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
        if (ObjectUtils.isEmpty((Object[])types)) {
            return null;
        }
        return ConverterPair.of(types[0], types[1]);
    }

    public Class<?> getSourceType() {
        return this.sourceType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return "ConverterPair(sourceType=" + String.valueOf(this.getSourceType()) + ", targetType=" + String.valueOf(this.getTargetType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConverterPair)) {
            return false;
        }
        ConverterPair other = (ConverterPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$sourceType = this.getSourceType();
        Class<?> other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        Class<?> this$targetType = this.getTargetType();
        Class<?> other$targetType = other.getTargetType();
        return !(this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConverterPair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        Class<?> $targetType = this.getTargetType();
        result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
        return result;
    }
}

