/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.mapstruct.converter;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MapstructService {
    public <S, T> T convert(S var1, Class<T> var2);

    default public <S, T> Stream<T> convert(Collection<S> sources, Class<T> targetType) {
        if (sources == null || sources.isEmpty()) {
            return Stream.empty();
        }
        return sources.stream().map(source -> this.convert(source, targetType));
    }

    default public <S, T> List<T> convertList(Collection<S> sources, Class<T> targetType) {
        return this.convert(sources, targetType).collect(Collectors.toList());
    }

    default public <S, T> List<T> convertUnmodifiableList(Collection<S> sources, Class<T> targetType) {
        return this.convert(sources, targetType).toList();
    }

    default public <S, T> Set<T> convertSet(Collection<S> sources, Class<T> targetType) {
        return this.convert(sources, targetType).collect(Collectors.toSet());
    }

    default public <S, T> Set<T> convertUnmodifiableSet(Collection<S> sources, Class<T> targetType) {
        return this.convert(sources, targetType).collect(Collectors.toUnmodifiableSet());
    }
}

