/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.mybatisplugins.inject;

import com.livk.commons.util.BeanUtils;
import com.livk.commons.util.ReflectionUtils;
import com.livk.context.mybatisplugins.inject.annotation.SqlFunction;
import com.livk.context.mybatisplugins.inject.enums.SqlFill;
import com.livk.context.mybatisplugins.inject.handler.FunctionHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SqlDataInjection
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        HashMap<Object, List> map = new HashMap<Object, List>();
        if (parameter instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)parameter;
            for (Object value : paramMap.values()) {
                map.putIfAbsent(value, ReflectionUtils.getAllFields(value.getClass()));
            }
        } else {
            map.putIfAbsent(parameter, ReflectionUtils.getAllFields(parameter.getClass()));
        }
        for (Map.Entry entry : map.entrySet()) {
            if (SqlCommandType.DELETE.equals((Object)sqlCommandType)) continue;
            for (Field field : (List)entry.getValue()) {
                SqlFunction sqlFunction;
                Object value;
                if (!field.isAnnotationPresent(SqlFunction.class) || (value = this.getValue(sqlFunction = field.getAnnotation(SqlFunction.class))) == null || !SqlCommandType.INSERT.equals((Object)sqlCommandType) && !sqlFunction.fill().equals((Object)SqlFill.INSERT_UPDATE)) continue;
                Method writeMethod = ReflectionUtils.getWriteMethod(entry.getKey().getClass(), (Field)field);
                writeMethod.invoke(entry.getKey(), value);
            }
        }
        return invocation.proceed();
    }

    private Object getValue(SqlFunction sqlFunction) {
        Object value = sqlFunction.time().handler();
        return value != null ? value : ((FunctionHandle)BeanUtils.instantiateClass(sqlFunction.supplier())).handler();
    }
}

