/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.qrcode;

import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.livk.context.qrcode.PicType;
import java.awt.Color;

public record QRCodeEntity<T>(T content, int width, int height, MatrixToImageConfig config, PicType type) {
    public static <T> QRCodeEntityBuilder<T> builder(T content) {
        return new QRCodeEntityBuilder<T>(content);
    }

    public static class QRCodeEntityBuilder<T> {
        private final T content;
        private Integer width = 400;
        private Integer height = 400;
        private int onColor = -16777216;
        private int offColor = -1;
        private PicType type = PicType.PNG;

        QRCodeEntityBuilder(T content) {
            this.content = content;
        }

        public QRCodeEntityBuilder<T> width(int width) {
            this.width = width;
            return this;
        }

        public QRCodeEntityBuilder<T> height(int height) {
            this.height = height;
            return this;
        }

        public QRCodeEntityBuilder<T> onColor(int onColor) {
            this.onColor = onColor;
            return this;
        }

        public QRCodeEntityBuilder<T> onColor(Color color) {
            this.onColor = color.getRGB();
            return this;
        }

        public QRCodeEntityBuilder<T> offColor(int offColor) {
            this.offColor = offColor;
            return this;
        }

        public QRCodeEntityBuilder<T> offColor(Color color) {
            this.offColor = color.getRGB();
            return this;
        }

        public QRCodeEntityBuilder<T> type(PicType type) {
            this.type = type;
            return this;
        }

        public QRCodeEntity<T> build() {
            MatrixToImageConfig imageConfig = new MatrixToImageConfig(this.onColor, this.offColor);
            return new QRCodeEntity<T>(this.content, this.width, this.height, imageConfig, this.type);
        }
    }
}

