/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.qrcode;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.livk.context.qrcode.exception.QRCodeException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;

public final class QRCodeUtils {
    public static String parseQRCode(InputStream inputStream) {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            Result result = new MultiFormatReader().decode(binaryBitmap, hints);
            return result.getText();
        }
        catch (NotFoundException | IOException e) {
            throw new QRCodeException(e);
        }
    }

    private QRCodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

