/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.qrcode.resolver;

import com.livk.commons.util.AnnotationUtils;
import com.livk.context.qrcode.PicType;
import com.livk.context.qrcode.QRCodeGenerator;
import com.livk.context.qrcode.annotation.ResponseQRCode;
import com.livk.context.qrcode.support.QRCodeGeneratorSupport;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class QRCodeMethodReturnValueHandler
extends QRCodeGeneratorSupport
implements AsyncHandlerMethodReturnValueHandler {
    public QRCodeMethodReturnValueHandler(QRCodeGenerator qrCodeGenerator) {
        super(qrCodeGenerator);
    }

    public boolean supportsReturnType(@NonNull MethodParameter returnType) {
        return AnnotationUtils.hasAnnotationElement((MethodParameter)returnType, ResponseQRCode.class);
    }

    public void handleReturnValue(Object returnValue, @NonNull MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws IOException {
        mavContainer.setRequestHandled(true);
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        Assert.notNull((Object)response, (String)"response not be null");
        AnnotationAttributes attributes = this.createAttributes(returnValue, returnType, ResponseQRCode.class);
        PicType type = (PicType)attributes.getEnum("type");
        BufferedImage bufferedImage = this.toBufferedImage(returnValue, attributes);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.setResponse(type, response);
            this.write(bufferedImage, type.name(), (OutputStream)outputStream);
        }
    }

    private void setResponse(PicType type, HttpServletResponse response) {
        response.setContentType(type == PicType.JPG ? "image/jpeg" : "image/png");
        response.setCharacterEncoding("UTF-8");
    }

    public boolean isAsyncReturnValue(Object returnValue, @NonNull MethodParameter returnType) {
        return AnnotationUtils.hasAnnotationElement((MethodParameter)returnType, ResponseQRCode.class);
    }
}

