/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.qrcode.resolver;

import com.livk.commons.io.DataBufferUtils;
import com.livk.commons.util.AnnotationUtils;
import com.livk.context.qrcode.PicType;
import com.livk.context.qrcode.QRCodeEntity;
import com.livk.context.qrcode.QRCodeGenerator;
import com.livk.context.qrcode.annotation.ResponseQRCode;
import com.livk.context.qrcode.exception.QRCodeException;
import com.livk.context.qrcode.support.QRCodeGeneratorSupport;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQRCodeMethodReturnValueHandler
extends QRCodeGeneratorSupport
implements HandlerResultHandler,
Ordered {
    private final ReactiveAdapterRegistry adapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

    public ReactiveQRCodeMethodReturnValueHandler(QRCodeGenerator qrCodeGenerator) {
        super(qrCodeGenerator);
    }

    public boolean supports(@NonNull HandlerResult result) {
        return AnnotationUtils.hasAnnotationElement((MethodParameter)result.getReturnTypeSource(), ResponseQRCode.class) || result.getReturnType().isAssignableFrom(QRCodeEntity.class);
    }

    @NonNull
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        Object returnValue = result.getReturnValue();
        ServerHttpResponse response = exchange.getResponse();
        ResolvableType returnType = result.getReturnType();
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(returnType.resolve(), returnValue);
        if (adapter != null) {
            if (Mono.class.isAssignableFrom(returnType.toClass())) {
                Mono mono = (Mono)returnValue;
                Assert.notNull((Object)mono, (String)"mono not be null");
                return mono.flatMap(o -> this.write(o, result.getReturnTypeSource(), response));
            }
        } else {
            return this.write(returnValue, result.getReturnTypeSource(), response);
        }
        throw new QRCodeException("current type is not supported:" + String.valueOf(returnType.toClass()));
    }

    private Mono<Void> write(Object value, MethodParameter parameter, ServerHttpResponse response) {
        AnnotationAttributes attributes = this.createAttributes(value, parameter, ResponseQRCode.class);
        PicType type = (PicType)attributes.getEnum("type");
        this.setResponse(type, response);
        byte[] bytes = this.toByteArray(value, attributes);
        Flux bufferFlux = DataBufferUtils.transform((byte[])bytes);
        return response.writeWith((Publisher)bufferFlux);
    }

    private void setResponse(PicType type, ServerHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        headers.setContentType(type == PicType.JPG ? MediaType.IMAGE_JPEG : MediaType.IMAGE_PNG);
        headers.setAcceptCharset(List.of(StandardCharsets.UTF_8));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

