/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.qrcode.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.livk.commons.jackson.core.JacksonOps;
import com.livk.commons.jackson.core.JacksonSupport;
import com.livk.context.qrcode.PicType;
import com.livk.context.qrcode.QRCodeGenerator;
import com.livk.context.qrcode.exception.QRCodeException;
import com.livk.context.qrcode.support.AbstractQRCodeGenerator;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleQRCodeGenerator
extends AbstractQRCodeGenerator
implements QRCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(GoogleQRCodeGenerator.class);
    private final JacksonOps jacksonOps;

    public GoogleQRCodeGenerator(ObjectMapper mapper) {
        this.jacksonOps = new JacksonSupport(mapper);
    }

    @Override
    protected String convert(Object content) {
        return this.jacksonOps.writeValueAsString(content);
    }

    @Override
    public BufferedImage generateQRCode(String content, int width, int height, MatrixToImageConfig config, PicType type) {
        try {
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix matrix = writer.encode(content, BarcodeFormat.QR_CODE, width, height);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix, (MatrixToImageConfig)config);
        }
        catch (WriterException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new QRCodeException("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", e);
        }
    }
}

