/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.qrcode.support;

import com.livk.commons.util.AnnotationUtils;
import com.livk.commons.util.BeanUtils;
import com.livk.context.qrcode.PicType;
import com.livk.context.qrcode.QRCodeEntity;
import com.livk.context.qrcode.QRCodeGenerator;
import com.livk.context.qrcode.exception.QRCodeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import javax.imageio.ImageIO;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationAttributes;

public abstract class QRCodeGeneratorSupport {
    private final QRCodeGenerator qrCodeGenerator;

    protected AnnotationAttributes createAttributes(Object returnValue, MethodParameter parameter, Class<? extends Annotation> annotationClass) {
        if (returnValue instanceof QRCodeEntity) {
            QRCodeEntity entity = (QRCodeEntity)returnValue;
            Map map = BeanUtils.convert((Object)entity);
            return AnnotationAttributes.fromMap((Map)map);
        }
        Annotation annotation = AnnotationUtils.getAnnotationElement((MethodParameter)parameter, annotationClass);
        return AnnotationUtils.getAnnotationAttributes((AnnotatedElement)parameter.getMethod(), (Annotation)annotation);
    }

    protected BufferedImage toBufferedImage(Object returnValue, AnnotationAttributes attributes) {
        if (returnValue instanceof QRCodeEntity) {
            QRCodeEntity entity = (QRCodeEntity)returnValue;
            return this.qrCodeGenerator.generateQRCode(entity);
        }
        QRCodeEntity<Object> entity = QRCodeEntity.builder(returnValue).height(attributes.getNumber("width").intValue()).width(attributes.getNumber("height").intValue()).onColor(attributes.getNumber("onColor").intValue()).offColor(attributes.getNumber("offColor").intValue()).type((PicType)attributes.getEnum("type")).build();
        return this.qrCodeGenerator.generateQRCode(entity);
    }

    protected byte[] toByteArray(Object returnValue, AnnotationAttributes attributes) {
        BufferedImage bufferedImage = this.toBufferedImage(returnValue, attributes);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String formatName = attributes.getEnum("type").name();
        this.write(bufferedImage, formatName, stream);
        return stream.toByteArray();
    }

    protected void write(BufferedImage bufferedImage, String formatName, OutputStream stream) {
        try {
            ImageIO.write((RenderedImage)bufferedImage, formatName, stream);
        }
        catch (IOException e) {
            throw new QRCodeException("\u4e8c\u7ef4\u7801\u5199\u5165\u5931\u8d25", e);
        }
    }

    protected QRCodeGeneratorSupport(QRCodeGenerator qrCodeGenerator) {
        this.qrCodeGenerator = qrCodeGenerator;
    }
}

