/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.redis;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.livk.commons.jackson.util.TypeFactoryUtils;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

public final class JacksonSerializerUtils {
    public static <T> RedisSerializer<T> json(Class<T> targetClass) {
        return JacksonSerializerUtils.json(TypeFactoryUtils.javaType(targetClass));
    }

    public static <T> RedisSerializer<T> json(JavaType javaType) {
        ObjectMapper mapper = JsonMapper.builder().build();
        mapper.registerModules(new Module[]{new JavaTimeModule()});
        return new Jackson2JsonRedisSerializer(mapper, javaType);
    }

    public static RedisSerializer<Object> json() {
        return JacksonSerializerUtils.json(Object.class);
    }

    private JacksonSerializerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

