/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.useragent.servlet;

import com.livk.commons.util.WebUtils;
import com.livk.context.useragent.UserAgentHelper;
import com.livk.context.useragent.annotation.UserAgentInfo;
import com.livk.context.useragent.domain.UserAgent;
import com.livk.context.useragent.servlet.UserAgentContextHolder;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class UserAgentResolver
implements HandlerMethodArgumentResolver {
    private final UserAgentHelper helper;

    public final boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(UserAgentInfo.class);
    }

    public final Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        UserAgent agentContext = UserAgentContextHolder.getUserAgentContext();
        if (agentContext == null) {
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            Assert.notNull((Object)request, (String)"request not be null!");
            HttpHeaders headers = WebUtils.headers((HttpServletRequest)request);
            agentContext = this.helper.convert(headers);
            UserAgentContextHolder.setUserAgentContext(agentContext);
        }
        return agentContext;
    }

    public UserAgentResolver(UserAgentHelper helper) {
        this.helper = helper;
    }
}

