/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.quarkus.resteasy.runtime.NonJaxRsClassMappings;
import io.quarkus.resteasy.runtime.ResteasyVertxConfig;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.ResteasyConfigurationMPConfig;
import io.quarkus.resteasy.runtime.standalone.VertxRequestHandler;
import io.quarkus.resteasy.runtime.standalone.VertxUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.vertx.http.runtime.HttpCompressionHandler;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.devmode.ResourceNotFoundData;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteMethodDescription;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

@Recorder
public class ResteasyStandaloneRecorder {
    static final String RESTEASY_URI_INFO = ResteasyUriInfo.class.getName();
    private static boolean useDirect = true;
    private static ResteasyDeployment deployment;
    private static String contextPath;
    private final ResteasyVertxConfig runtimeConfig;
    private final VertxHttpBuildTimeConfig httpBuildTimeConfig;
    private final RuntimeValue<VertxHttpConfig> httpRuntimeConfig;

    public ResteasyStandaloneRecorder(ResteasyVertxConfig runtimeConfig, VertxHttpBuildTimeConfig httpBuildTimeConfig, RuntimeValue<VertxHttpConfig> httpRuntimeConfig) {
        this.runtimeConfig = runtimeConfig;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
        this.httpRuntimeConfig = httpRuntimeConfig;
    }

    public void staticInit(ResteasyDeployment dep, String path) {
        if (dep != null) {
            deployment = dep;
            deployment.getDefaultContextObjects().put(ResteasyConfiguration.class, new ResteasyConfigurationMPConfig());
            deployment.start();
        }
        contextPath = path;
    }

    public void start(ShutdownContext shutdown, boolean isVirtual) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (deployment != null) {
                    deployment.stop();
                }
            }
        });
        useDirect = !isVirtual;
    }

    public Handler<RoutingContext> vertxRequestHandler(Supplier<Vertx> vertx, Executor executor, Map<String, NonJaxRsClassMappings> nonJaxRsClassNameToMethodPaths) {
        if (deployment != null) {
            VertxRequestHandler handler = new VertxRequestHandler(vertx.get(), deployment, contextPath, new ResteasyVertxAllocator(this.runtimeConfig.responseBufferSize()), executor, ((VertxHttpConfig)this.httpRuntimeConfig.getValue()).readTimeout().toMillis());
            Set compressMediaTypes = this.httpBuildTimeConfig.compressMediaTypes().map(Set::copyOf).orElse(Set.of());
            if (this.httpBuildTimeConfig.enableCompression() && !compressMediaTypes.isEmpty()) {
                handler = new HttpCompressionHandler((Handler)handler, compressMediaTypes);
            }
            if (LaunchMode.current() == LaunchMode.DEVELOPMENT) {
                Registry registry = deployment.getRegistry();
                ResourceNotFoundData.setRuntimeRoutes(this.fromBoundResourceInvokers(registry, nonJaxRsClassNameToMethodPaths));
            }
            return handler;
        }
        return null;
    }

    public Handler<RoutingContext> vertxFailureHandler(Supplier<Vertx> vertx, Executor executor, final boolean noCustomAuthCompletionExMapper, final boolean noCustomAuthFailureExMapper, final boolean noCustomAuthRedirectExMapper) {
        if (deployment == null) {
            return null;
        }
        return new VertxRequestHandler(vertx.get(), deployment, contextPath, new ResteasyVertxAllocator(this.runtimeConfig.responseBufferSize()), executor, ((VertxHttpConfig)this.httpRuntimeConfig.getValue()).readTimeout().toMillis()){

            @Override
            public void handle(RoutingContext request) {
                boolean isOtherAuthFailure;
                if (ResteasyStandaloneRecorder.this.httpBuildTimeConfig.auth().proactive() && request.get("io.quarkus.vertx.http.auth-failure-handler") instanceof HttpSecurityRecorder.DefaultAuthFailureHandler) {
                    if (request.failure() instanceof AuthenticationFailedException) {
                        if (noCustomAuthFailureExMapper) {
                            request.next();
                        } else {
                            super.handle(request);
                        }
                        return;
                    }
                    if (request.failure() instanceof AuthenticationCompletionException) {
                        if (noCustomAuthCompletionExMapper) {
                            request.next();
                        } else {
                            super.handle(request);
                        }
                        return;
                    }
                    if (request.failure() instanceof AuthenticationRedirectException) {
                        if (noCustomAuthRedirectExMapper) {
                            request.next();
                        } else {
                            super.handle(request);
                        }
                        return;
                    }
                }
                Throwable failure = request.failure();
                boolean bl = isOtherAuthFailure = HttpSecurityRecorder.DefaultAuthFailureHandler.isOtherAuthenticationFailure((RoutingContext)request) && ResteasyStandaloneRecorder.this.isFailureHandledByExceptionMappers(failure);
                if (isOtherAuthFailure) {
                    HttpSecurityRecorder.DefaultAuthFailureHandler.removeMarkAsOtherAuthenticationFailure((RoutingContext)request);
                    super.handle(request);
                } else if (failure instanceof AuthenticationException || failure instanceof UnauthorizedException || failure instanceof ForbiddenException) {
                    super.handle(request);
                } else {
                    request.next();
                }
            }

            @Override
            protected void setCurrentIdentityAssociation(RoutingContext routingContext) {
            }
        };
    }

    private boolean isFailureHandledByExceptionMappers(Throwable failure) {
        return failure != null && deployment != null && deployment.getProviderFactory().getExceptionMapper(failure.getClass()) != null;
    }

    public Handler<RoutingContext> defaultAuthFailureHandler() {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (deployment != null && event.get("io.quarkus.vertx.http.auth-failure-handler") instanceof HttpSecurityRecorder.DefaultAuthFailureHandler) {
                    try {
                        event.put(RESTEASY_URI_INFO, (Object)VertxUtil.extractUriInfo(event.request(), contextPath));
                    }
                    catch (Exception e) {
                        event.next();
                        return;
                    }
                    event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new BiConsumer<RoutingContext, Throwable>(){

                        @Override
                        public void accept(RoutingContext event, Throwable throwable) {
                            HttpSecurityRecorder.DefaultAuthFailureHandler.markIfOtherAuthenticationFailure((RoutingContext)event, (Throwable)throwable);
                            if (!event.failed()) {
                                event.fail(HttpSecurityRecorder.DefaultAuthFailureHandler.extractRootCause((Throwable)throwable));
                            }
                        }
                    });
                }
                event.next();
            }
        };
    }

    private List<RouteDescription> fromBoundResourceInvokers(Registry registry, Map<String, NonJaxRsClassMappings> nonJaxRsClassNameToMethodPaths) {
        Set<Map.Entry<String, List<ResourceInvoker>>> bound = this.getBounded(registry).entrySet();
        HashMap<String, RouteDescription> descriptionMap = new HashMap<String, RouteDescription>();
        for (Map.Entry<String, List<ResourceInvoker>> entry : bound) {
            for (ResourceInvoker invoker : entry.getValue()) {
                if (!(invoker instanceof ResourceMethodInvoker)) continue;
                ResourceMethodInvoker method = (ResourceMethodInvoker)invoker;
                Class resourceClass = method.getResourceClass();
                String resourceClassName = resourceClass.getName();
                String basePath = null;
                NonJaxRsClassMappings nonJaxRsClassMappings = null;
                Path path = resourceClass.getAnnotation(Path.class);
                if (path == null) {
                    nonJaxRsClassMappings = nonJaxRsClassNameToMethodPaths.get(resourceClassName);
                    if (nonJaxRsClassMappings != null) {
                        basePath = nonJaxRsClassMappings.getBasePath();
                    }
                } else {
                    basePath = path.value();
                }
                if (basePath == null) continue;
                RouteDescription description = (RouteDescription)descriptionMap.get(basePath);
                if (description == null) {
                    description = new RouteDescription(basePath);
                    descriptionMap.put(basePath, description);
                }
                String subPath = "";
                for (Annotation annotation : method.getMethodAnnotations()) {
                    if (!annotation.annotationType().equals(Path.class)) continue;
                    subPath = ((Path)annotation).value();
                    break;
                }
                if (subPath.isEmpty() && nonJaxRsClassMappings != null) {
                    String methodName = method.getMethod().getName();
                    String subPathFromMethodName = nonJaxRsClassMappings.getMethodNameToPath().get(methodName);
                    if (subPathFromMethodName != null) {
                        subPath = subPathFromMethodName;
                    }
                }
                Object fullPath = basePath;
                if (!subPath.isEmpty()) {
                    fullPath = basePath.endsWith("/") ? (String)fullPath + subPath : basePath + (subPath.startsWith("/") ? "" : "/") + subPath;
                }
                String produces = this.mostPreferredOrNull(method.getProduces());
                String consumes = this.mostPreferredOrNull(method.getConsumes());
                for (String verb : method.getHttpMethods()) {
                    description.addCall(new RouteMethodDescription(verb, (String)fullPath, produces, consumes));
                }
            }
        }
        ArrayList<RouteDescription> descriptions = new ArrayList<RouteDescription>(descriptionMap.values());
        return descriptions;
    }

    private String mostPreferredOrNull(MediaType[] mediaTypes) {
        if (mediaTypes == null || mediaTypes.length < 1) {
            return null;
        }
        return mediaTypes[0].toString();
    }

    private Map<String, List<ResourceInvoker>> getBounded(Registry registry) {
        Map bounded = null;
        if (registry instanceof ResourceMethodRegistry) {
            bounded = ((ResourceMethodRegistry)registry).getBounded();
        } else if (Proxy.isProxyClass(registry.getClass()) && registry.toString().startsWith(ResourceMethodRegistry.class.getName())) {
            try {
                bounded = (Map)Proxy.getInvocationHandler(registry).invoke(registry, ResourceMethodRegistry.class.getMethod("getBounded", new Class[0]), new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return bounded;
    }

    private static class ResteasyVertxAllocator
    implements BufferAllocator {
        private final int bufferSize;

        private ResteasyVertxAllocator(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public ByteBuf allocateBuffer() {
            return this.allocateBuffer(useDirect);
        }

        @Override
        public ByteBuf allocateBuffer(boolean direct) {
            return this.allocateBuffer(direct, this.bufferSize);
        }

        @Override
        public ByteBuf allocateBuffer(int bufferSize) {
            return this.allocateBuffer(useDirect, bufferSize);
        }

        @Override
        public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
            if (direct) {
                return PooledByteBufAllocator.DEFAULT.directBuffer(bufferSize);
            }
            return PooledByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
        }

        @Override
        public int getBufferSize() {
            return this.bufferSize;
        }
    }
}

