/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.properties.PropertyResolver;
import org.codehaus.mojo.properties.ResourceType;
import org.codehaus.mojo.properties.YamlToPropertiesConverter;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="read-project-properties", defaultPhase=LifecyclePhase.NONE, requiresProject=true, threadSafe=true)
public class ReadPropertiesMojo
extends AbstractMojo {
    private static final ResourceType[] SUPPORTED_RESOURCE_TYPES = new ResourceType[]{ResourceType.PROPERTIES, ResourceType.YAML};
    private final PropertyResolver resolver = new PropertyResolver();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private File[] files = new File[0];
    @Parameter
    private String[] urls = new String[0];
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter
    private String keyPrefix;

    private static ResourceType identifyResourceType(String fileName) throws MojoExecutionException {
        ResourceType resourceType = ResourceType.getByFileName(fileName);
        if (resourceType == null) {
            throw new MojoExecutionException("Cannot find a resource type for " + fileName);
        }
        return resourceType;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParameters();
        this.loadFiles();
        this.loadUrls();
        this.resolveProperties();
    }

    private void checkParameters() throws MojoExecutionException {
        if (this.files.length > 0 && this.urls.length > 0) {
            throw new MojoExecutionException("Set files or URLs but not both - otherwise no order of precedence can be guaranteed");
        }
        for (File file : this.files) {
            if (!file.isFile()) {
                throw new MojoExecutionException(String.format("File expected, but %s is not a file", file.getPath()));
            }
            if (this.endsWithExtension(file.getAbsolutePath())) continue;
            throw new MojoExecutionException(String.format("File name must ends with '.properties', '.yml' or '.yaml', while file '%s' was found", file.getName()));
        }
        for (String url : this.urls) {
            if (this.endsWithExtension(url)) continue;
            throw new MojoExecutionException(String.format("Url must ends with '.properties', '.yml' or '.yaml', while url '%s' was found", url));
        }
    }

    private void loadFiles() throws MojoExecutionException {
        for (File file : this.files) {
            this.load(new FileResource(file));
        }
    }

    private void loadUrls() throws MojoExecutionException {
        for (String url : this.urls) {
            this.load(new UrlResource(url));
        }
    }

    private void load(Resource resource) throws MojoExecutionException {
        if (resource.canBeOpened()) {
            this.loadProperties(resource);
        } else {
            this.missing(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(Resource resource) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("Loading properties from " + resource));
            ResourceType resourceType = resource.getResourceType();
            InputStream stream = resource.getInputStream();
            try {
                Properties properties;
                switch (resourceType) {
                    case PROPERTIES: {
                        properties = new Properties();
                        properties.load(stream);
                        break;
                    }
                    case YAML: {
                        properties = YamlToPropertiesConverter.convertToProperties(stream);
                        break;
                    }
                    default: {
                        throw new MojoExecutionException("Error reading properties from " + resource, (Exception)new UnsupportedOperationException(String.format("Resource Type %s is unknown", new Object[]{resourceType})));
                    }
                }
                Properties projectProperties = this.project.getProperties();
                for (String key : properties.stringPropertyNames()) {
                    projectProperties.put(this.keyPrefix != null ? this.keyPrefix + key : key, properties.get(key));
                }
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading properties from " + resource, (Exception)e);
        }
    }

    private void missing(Resource resource) throws MojoExecutionException {
        if (!this.quiet) {
            throw new MojoExecutionException("Properties could not be loaded from " + resource);
        }
        this.getLog().info((CharSequence)("Quiet processing - ignoring properties cannot be loaded from " + resource));
    }

    private void resolveProperties() throws MojoExecutionException, MojoFailureException {
        Properties environment = this.loadSystemEnvironmentPropertiesWhenDefined();
        Properties projectProperties = this.project.getProperties();
        Enumeration<?> n = projectProperties.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            projectProperties.setProperty(k, this.getPropertyValue(k, projectProperties, environment));
        }
    }

    private Properties loadSystemEnvironmentPropertiesWhenDefined() throws MojoExecutionException {
        Properties projectProperties = this.project.getProperties();
        boolean useEnvVariables = false;
        Enumeration<?> n = projectProperties.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            String p = (String)projectProperties.get(k);
            if (p.indexOf("${env.") == -1) continue;
            useEnvVariables = true;
            break;
        }
        if (useEnvVariables) {
            try {
                return this.getSystemEnvVars();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error getting system environment variables: ", (Exception)e);
            }
        }
        return null;
    }

    private String getPropertyValue(String k, Properties p, Properties environment) throws MojoFailureException {
        try {
            return this.resolver.getPropertyValue(k, p, environment);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars();
    }

    void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    private boolean endsWithExtension(String text) {
        for (String extension : ResourceType.allFileExtensions(SUPPORTED_RESOURCE_TYPES)) {
            if (!text.toLowerCase().endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private static class UrlResource
    extends Resource {
        private static final String CLASSPATH_PREFIX = "classpath:";
        private static final String SLASH_PREFIX = "/";
        private final URL url;
        private boolean isMissingClasspathResource = false;
        private String classpathUrl;

        public UrlResource(String url) throws MojoExecutionException {
            super(ReadPropertiesMojo.identifyResourceType(url));
            if (url.startsWith(CLASSPATH_PREFIX)) {
                String resource = url.substring(CLASSPATH_PREFIX.length(), url.length());
                if (resource.startsWith(SLASH_PREFIX)) {
                    resource = resource.substring(1, resource.length());
                }
                this.url = this.getClass().getClassLoader().getResource(resource);
                if (this.url == null) {
                    this.isMissingClasspathResource = true;
                    this.classpathUrl = url;
                }
            } else {
                try {
                    this.url = new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(String.format("Badly formed URL %s - %s", url, e.getMessage()));
                }
            }
        }

        public boolean canBeOpened() {
            if (this.isMissingClasspathResource) {
                return false;
            }
            try {
                this.openStream();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        protected InputStream openStream() throws IOException {
            return new BufferedInputStream(this.url.openStream());
        }

        public String toString() {
            if (!this.isMissingClasspathResource) {
                return "URL " + this.url.toString();
            }
            return this.classpathUrl;
        }
    }

    private static class FileResource
    extends Resource {
        private final File file;

        public FileResource(File file) throws MojoExecutionException {
            super(ReadPropertiesMojo.identifyResourceType(file.getName()));
            this.file = file;
        }

        public boolean canBeOpened() {
            return this.file.exists();
        }

        protected InputStream openStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        public String toString() {
            return "File: " + this.file;
        }
    }

    private static abstract class Resource {
        private final ResourceType resourceType;
        private InputStream stream;

        protected Resource(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public abstract boolean canBeOpened();

        protected abstract InputStream openStream() throws IOException;

        public InputStream getInputStream() throws IOException {
            if (this.stream == null) {
                this.stream = this.openStream();
            }
            return this.stream;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }
    }
}

