/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthMicrosoftScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public abstract class AbstractAuthMicrosoftRequest
extends AuthDefaultRequest {
    public AbstractAuthMicrosoftRequest(AuthConfig config, AuthSource source) {
        super(config, source);
    }

    public AbstractAuthMicrosoftRequest(AuthConfig config, AuthSource source, AuthStateCache authStateCache) {
        super(config, source, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    private AuthToken getToken(String accessTokenUrl) {
        HttpHeader httpHeader = new HttpHeader();
        Map form = MapUtil.parseStringToMap((String)accessTokenUrl, (boolean)false);
        String response = new HttpUtils(this.config.getHttpConfig()).post(accessTokenUrl, form, httpHeader, false).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String token = authToken.getAccessToken();
        String tokenType = authToken.getTokenType();
        String jwt = tokenType + " " + token;
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", jwt);
        String userInfo = new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken), null, httpHeader, false).getBody();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        this.checkResponse(object);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("id")).username(object.getString("userPrincipalName")).nickname(object.getString("displayName")).location(object.getString("officeLocation")).email(object.getString("mail")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(authToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        String tenantId = StringUtils.isEmpty(this.config.getTenantId()) ? "common" : this.config.getTenantId();
        return UrlBuilder.fromBaseUrl(String.format(this.source.authorize(), tenantId)).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("response_mode", "query").queryParam("scope", this.getScopes(" ", false, AuthScopeUtils.getDefaultScopes(AuthMicrosoftScope.values()))).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        String tenantId = StringUtils.isEmpty(this.config.getTenantId()) ? "common" : this.config.getTenantId();
        return UrlBuilder.fromBaseUrl(String.format(this.source.accessToken(), tenantId)).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").queryParam("scope", this.getScopes(" ", false, AuthScopeUtils.getDefaultScopes(AuthMicrosoftScope.values()))).queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        String tenantId = StringUtils.isEmpty(this.config.getTenantId()) ? "common" : this.config.getTenantId();
        return UrlBuilder.fromBaseUrl(String.format(this.source.refresh(), tenantId)).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").queryParam("scope", this.getScopes(" ", false, AuthScopeUtils.getDefaultScopes(AuthMicrosoftScope.values()))).queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }
}

