/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.parser;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.parser.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.parser.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;

public final class SQLParserExecutor {
    private final String databaseType;
    private final Cache<String, ParseTree> cache = CacheBuilder.newBuilder().softValues().initialCapacity(2000).maximumSize(65535L).build();

    public ParseTree parse(String sql, boolean useCache) {
        if (!useCache) {
            return this.parse(sql);
        }
        return this.parseAndCacheParseTree(sql);
    }

    private ParseTree parse(String sql) {
        ParseASTNode result = this.twoPhaseParse(sql);
        if (result.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException("Unsupported SQL of `%s`", sql);
        }
        return result.getRootNode();
    }

    private ParseTree parseAndCacheParseTree(String sql) {
        Optional<Object> parseTree = Optional.ofNullable(this.cache.getIfPresent((Object)sql));
        if (parseTree.isPresent()) {
            return (ParseTree)parseTree.get();
        }
        ParseTree result = this.parse(sql);
        this.cache.put((Object)sql, (Object)result);
        return result;
    }

    private ParseASTNode twoPhaseParse(String sql) {
        SQLParser sqlParser = SQLParserFactory.newInstance(this.databaseType, sql);
        try {
            this.setPredictionMode((Parser)sqlParser, PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            this.setPredictionMode((Parser)sqlParser, PredictionMode.LL);
            return (ParseASTNode)sqlParser.parse();
        }
    }

    private void setPredictionMode(Parser sqlParser, PredictionMode mode) {
        sqlParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        ((ParserATNSimulator)sqlParser.getInterpreter()).setPredictionMode(mode);
    }

    @Generated
    public SQLParserExecutor(String databaseType) {
        this.databaseType = databaseType;
    }
}

