/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.visitor;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.shardingsphere.sql.parser.spi.SQLVisitorFacade;

public final class SQLVisitorFacadeRegistry {
    private static final SQLVisitorFacadeRegistry INSTANCE = new SQLVisitorFacadeRegistry();
    private final Map<String, SQLVisitorFacade> facades = new LinkedHashMap<String, SQLVisitorFacade>();

    private SQLVisitorFacadeRegistry() {
        for (SQLVisitorFacade each : ServiceLoader.load(SQLVisitorFacade.class)) {
            this.facades.put(this.getQualifiedType(each.getDatabaseType(), each.getVisitorType()), each);
        }
    }

    public static SQLVisitorFacadeRegistry getInstance() {
        return INSTANCE;
    }

    public SQLVisitorFacade getSQLVisitorFacade(String databaseType, String visitorType) {
        String qualifiedType = this.getQualifiedType(databaseType, visitorType);
        if (this.facades.containsKey(qualifiedType)) {
            return this.facades.get(qualifiedType);
        }
        throw new UnsupportedOperationException(String.format("Cannot support '%s' visitor with database '%s'", visitorType, databaseType));
    }

    private String getQualifiedType(String databaseType, String visitorType) {
        return String.join((CharSequence)".", databaseType, visitorType);
    }
}

