/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl;

import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.TCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl.MySQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.tcl.AutoCommitSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLBeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLRollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.tcl.MySQLSetTransactionStatement;

public final class MySQLTCLStatementSQLVisitor
extends MySQLStatementSQLVisitor
implements TCLSQLVisitor,
SQLStatementVisitor {
    @Override
    public ASTNode visitSetTransaction(MySQLStatementParser.SetTransactionContext ctx) {
        MySQLSetTransactionStatement result = new MySQLSetTransactionStatement();
        if (null != ctx.scope()) {
            MySQLStatementParser.ScopeContext scopeContext = ctx.scope();
            if (null != scopeContext.GLOBAL()) {
                result.setScope(scopeContext.GLOBAL().getText());
            } else if (null != scopeContext.SESSION()) {
                result.setScope(scopeContext.SESSION().getText());
            }
        }
        if (null != ctx.transactionCharacteristic()) {
            for (MySQLStatementParser.TransactionCharacteristicContext each : ctx.transactionCharacteristic()) {
                if (null != each.level()) {
                    result.setIsolationLevel(each.level().getText());
                }
                if (null == each.accessMode()) continue;
                result.setAccessMode(each.accessMode().getText());
            }
        }
        return new MySQLSetTransactionStatement();
    }

    @Override
    public ASTNode visitSetAutoCommit(MySQLStatementParser.SetAutoCommitContext ctx) {
        MySQLSetAutoCommitStatement result = new MySQLSetAutoCommitStatement();
        result.setAutoCommit(((AutoCommitSegment)this.visit((ParseTree)ctx.autoCommitValue())).isAutoCommit());
        return result;
    }

    @Override
    public ASTNode visitAutoCommitValue(MySQLStatementParser.AutoCommitValueContext ctx) {
        boolean autoCommit = "1".equals(ctx.getText()) || "ON".equals(ctx.getText());
        return new AutoCommitSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), autoCommit);
    }

    @Override
    public ASTNode visitBeginTransaction(MySQLStatementParser.BeginTransactionContext ctx) {
        return new MySQLBeginTransactionStatement();
    }

    @Override
    public ASTNode visitCommit(MySQLStatementParser.CommitContext ctx) {
        return new MySQLCommitStatement();
    }

    @Override
    public ASTNode visitRollback(MySQLStatementParser.RollbackContext ctx) {
        return new MySQLRollbackStatement();
    }

    @Override
    public ASTNode visitSavepoint(MySQLStatementParser.SavepointContext ctx) {
        return new MySQLSavepointStatement();
    }
}

