/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.constant.LogicalOperator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.OrPredicateSegment;

public final class ExpressionBuilder {
    private final ExpressionSegment expression;

    public OrPredicateSegment extractAndPredicates() {
        OrPredicateSegment result = new OrPredicateSegment();
        if (this.expression instanceof BinaryOperationExpression) {
            String operator = ((BinaryOperationExpression)this.expression).getOperator();
            Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(operator);
            if (logicalOperator.isPresent() && LogicalOperator.OR == logicalOperator.get()) {
                ExpressionBuilder leftBuilder = new ExpressionBuilder(((BinaryOperationExpression)this.expression).getLeft());
                ExpressionBuilder rightBuilder = new ExpressionBuilder(((BinaryOperationExpression)this.expression).getRight());
                result.getAndPredicates().addAll(leftBuilder.extractAndPredicates().getAndPredicates());
                result.getAndPredicates().addAll(rightBuilder.extractAndPredicates().getAndPredicates());
            } else if (logicalOperator.isPresent() && LogicalOperator.AND == logicalOperator.get()) {
                ExpressionBuilder leftBuilder = new ExpressionBuilder(((BinaryOperationExpression)this.expression).getLeft());
                ExpressionBuilder rightBuilder = new ExpressionBuilder(((BinaryOperationExpression)this.expression).getRight());
                for (AndPredicate eachLeft : leftBuilder.extractAndPredicates().getAndPredicates()) {
                    for (AndPredicate eachRight : rightBuilder.extractAndPredicates().getAndPredicates()) {
                        result.getAndPredicates().add(this.createAndPredicate(eachLeft, eachRight));
                    }
                }
            } else {
                AndPredicate andPredicate = new AndPredicate();
                andPredicate.getPredicates().add(this.expression);
                result.getAndPredicates().add(andPredicate);
            }
        } else {
            AndPredicate andPredicate = new AndPredicate();
            andPredicate.getPredicates().add(this.expression);
            result.getAndPredicates().add(andPredicate);
        }
        return result;
    }

    private AndPredicate createAndPredicate(AndPredicate left, AndPredicate right) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().addAll(left.getPredicates());
        result.getPredicates().addAll(right.getPredicates());
        return result;
    }

    @Generated
    public ExpressionBuilder(ExpressionSegment expression) {
        this.expression = expression;
    }
}

