/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

public class Options {
    public static final String IN_PLACE = "in_place";
    public static final String WARNINGS = "warnings";
    public static final String TIMINGS = "timings";
    public static final String ATTRIBUTES = "attributes";
    public static final String TEMPLATE_DIRS = "template_dirs";
    public static final String TEMPLATE_ENGINE = "template_engine";
    public static final String TO_FILE = "to_file";
    public static final String TO_DIR = "to_dir";
    public static final String MKDIRS = "mkdirs";
    public static final String SAFE = "safe";
    public static final String SOURCEMAP = "sourcemap";
    public static final String STANDALONE = "standalone";
    public static final String ERUBY = "eruby";
    public static final String CATALOG_ASSETS = "catalog_assets";
    public static final String COMPACT = "compact";
    public static final String BACKEND = "backend";
    public static final String DOCTYPE = "doctype";
    public static final String BASEDIR = "base_dir";
    public static final String TRACE = "trace";
    public static final String TEMPLATE_CACHE = "template_cache";
    public static final String SOURCE = "source";
    public static final String PARSE = "parse";
    public static final String PARSE_HEADER_ONLY = "parse_header_only";
    private final Map<String, Object> options = new HashMap<String, Object>();

    Options() {
    }

    public static OptionsBuilder builder() {
        return new OptionsBuilder();
    }

    public void setInPlace(boolean inPlace) {
        this.options.put(IN_PLACE, inPlace);
    }

    public void setAttributes(Attributes attributes) {
        this.options.put(ATTRIBUTES, attributes.map());
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.options.put(ATTRIBUTES, attributes);
    }

    public void setStandalone(boolean standalone) {
        this.options.put(STANDALONE, standalone);
    }

    public void setTemplateDirs(String ... templateDirs) {
        if (!this.options.containsKey(TEMPLATE_DIRS)) {
            this.options.put(TEMPLATE_DIRS, new ArrayList());
        }
        List allTemplateDirs = (List)this.options.get(TEMPLATE_DIRS);
        allTemplateDirs.addAll(Arrays.asList(templateDirs));
    }

    public void setTemplateEngine(String templateEngine) {
        this.options.put(TEMPLATE_ENGINE, templateEngine);
    }

    public void setToFile(String toFile) {
        this.options.put(TO_FILE, toFile);
    }

    public void setToStream(OutputStream toStream) {
        this.options.put(TO_FILE, toStream);
    }

    public void setToFile(boolean toFile) {
        this.options.put(TO_FILE, toFile);
    }

    public void setToDir(String toDir) {
        this.options.put(TO_DIR, toDir);
    }

    public void setMkDirs(boolean mkDirs) {
        this.options.put(MKDIRS, mkDirs);
    }

    public void setSafe(SafeMode safeMode) {
        this.options.put(SAFE, safeMode.getLevel());
    }

    public void setSourcemap(boolean sourcemap) {
        this.options.put(SOURCEMAP, sourcemap);
    }

    public void setEruby(String eruby) {
        this.options.put(ERUBY, eruby);
    }

    public void setCatalogAssets(boolean catalogAssets) {
        this.options.put(CATALOG_ASSETS, catalogAssets);
    }

    public void setCompact(boolean compact) {
        this.options.put(COMPACT, compact);
    }

    public void setBackend(String backend) {
        this.options.put(BACKEND, backend);
    }

    public void setDocType(String docType) {
        this.options.put(DOCTYPE, docType);
    }

    public void setBaseDir(String baseDir) {
        this.options.put(BASEDIR, baseDir);
    }

    public void setTemplateCache(boolean templateCache) {
        this.options.put(TEMPLATE_CACHE, templateCache);
    }

    public void setParse(boolean parse) {
        this.options.put(PARSE, parse);
    }

    public void setParseHeaderOnly(boolean parseHeaderOnly) {
        this.options.put(PARSE_HEADER_ONLY, parseHeaderOnly);
    }

    public void setOption(String optionName, Object optionValue) {
        this.options.put(optionName, optionValue);
    }

    @Deprecated
    public Map<String, Object> map() {
        return this.options;
    }
}

