/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Catalog;
import org.asciidoctor.ast.Footnote;
import org.asciidoctor.ast.ImageReference;
import org.asciidoctor.ast.Link;
import org.asciidoctor.jruby.ast.impl.FootnoteImpl;
import org.asciidoctor.jruby.ast.impl.ImageReferenceImpl;
import org.asciidoctor.jruby.ast.impl.LinkImpl;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyStruct;

public class CatalogImpl
implements Catalog {
    private final Map<String, Object> catalog;

    public CatalogImpl(Map<String, Object> catalog) {
        this.catalog = catalog;
    }

    public List<Footnote> getFootnotes() {
        return ((RubyArray)this.catalog.get("footnotes")).stream().map(o -> FootnoteImpl.getInstance((RubyStruct)o)).collect(Collectors.toUnmodifiableList());
    }

    public List<ImageReference> getImages() {
        return ((RubyArray)this.catalog.get("images")).stream().map(o -> ImageReferenceImpl.getInstance((RubyStruct)o)).collect(Collectors.toUnmodifiableList());
    }

    public List<Link> getLinks() {
        return ((RubyArray)this.catalog.get("links")).stream().map(o -> LinkImpl.getInstance((String)o)).collect(Collectors.toUnmodifiableList());
    }

    public Map<String, Object> getRefs() {
        RubyHashMapDecorator refs = new RubyHashMapDecorator((RubyHash)this.catalog.get("refs"), String.class);
        return Collections.unmodifiableMap(refs);
    }
}

