/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hmily.config.api.AbstractConfig;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.api.event.DefaultConsumer;
import org.dromara.hmily.config.api.event.EventConsumer;
import org.dromara.hmily.config.api.event.EventData;
import org.dromara.hmily.config.api.exception.ConfigException;

public final class ConfigEnv {
    private static final ConfigEnv INST = new ConfigEnv();
    private static final Map<Class<?>, Config> CONFIGS = new ConcurrentHashMap();
    private static final Set<EventConsumer<EventData>> EVENTS = new HashSet<EventConsumer<EventData>>();

    private ConfigEnv() {
        if (INST != null) {
            throw new ConfigException("repeated configEnv object.");
        }
    }

    public static ConfigEnv getInstance() {
        return INST;
    }

    public void registerConfig(Config config) {
        if (config.getClass().getSuperclass().isAssignableFrom(AbstractConfig.class)) {
            this.putBean(config);
        }
    }

    public <T extends Config> T getConfig(Class<T> clazz) {
        return (T)CONFIGS.get(clazz);
    }

    public void putBean(Config parent) {
        if (parent != null && StringUtils.isNotBlank((CharSequence)parent.prefix())) {
            if (CONFIGS.containsKey(parent.getClass())) {
                return;
            }
            CONFIGS.put(parent.getClass(), parent);
        }
    }

    public synchronized <T extends EventData> void addEvent(EventConsumer<T> consumer) {
        EVENTS.add(consumer);
    }

    public Set<EventConsumer<EventData>> getEvents() {
        return Collections.unmodifiableSet(EVENTS);
    }

    public Stream<Config> stream() {
        return CONFIGS.values().stream();
    }

    static {
        EVENTS.add(new DefaultConsumer());
    }
}

