/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.api.entity;

import org.dromara.hmily.config.api.AbstractConfig;
import org.dromara.hmily.spi.HmilySPI;

@HmilySPI(value="hmilyRedisConfig")
public class HmilyRedisConfig
extends AbstractConfig {
    private boolean cluster;
    private boolean sentinel;
    private String clusterUrl;
    private String sentinelUrl;
    private String masterName;
    private String hostName;
    private int port;
    private String password;
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle;
    private long maxWaitMillis = -1L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = 1800000L;
    private int numTestsPerEvictionRun = 3;
    private boolean testOnCreate;
    private boolean testOnBorrow;
    private boolean testOnReturn;
    private boolean testWhileIdle;
    private long timeBetweenEvictionRunsMillis = -1L;
    private boolean blockWhenExhausted = true;
    private int timeOut = 10000;

    @Override
    public String prefix() {
        return "repository.redis";
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public boolean isSentinel() {
        return this.sentinel;
    }

    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public String getSentinelUrl() {
        return this.sentinelUrl;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    public void setSentinel(boolean sentinel) {
        this.sentinel = sentinel;
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    public void setSentinelUrl(String sentinelUrl) {
        this.sentinelUrl = sentinelUrl;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HmilyRedisConfig)) {
            return false;
        }
        HmilyRedisConfig other = (HmilyRedisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCluster() != other.isCluster()) {
            return false;
        }
        if (this.isSentinel() != other.isSentinel()) {
            return false;
        }
        String this$clusterUrl = this.getClusterUrl();
        String other$clusterUrl = other.getClusterUrl();
        if (this$clusterUrl == null ? other$clusterUrl != null : !this$clusterUrl.equals(other$clusterUrl)) {
            return false;
        }
        String this$sentinelUrl = this.getSentinelUrl();
        String other$sentinelUrl = other.getSentinelUrl();
        if (this$sentinelUrl == null ? other$sentinelUrl != null : !this$sentinelUrl.equals(other$sentinelUrl)) {
            return false;
        }
        String this$masterName = this.getMasterName();
        String other$masterName = other.getMasterName();
        if (this$masterName == null ? other$masterName != null : !this$masterName.equals(other$masterName)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.getMaxWaitMillis() != other.getMaxWaitMillis()) {
            return false;
        }
        if (this.getMinEvictableIdleTimeMillis() != other.getMinEvictableIdleTimeMillis()) {
            return false;
        }
        if (this.getSoftMinEvictableIdleTimeMillis() != other.getSoftMinEvictableIdleTimeMillis()) {
            return false;
        }
        if (this.getNumTestsPerEvictionRun() != other.getNumTestsPerEvictionRun()) {
            return false;
        }
        if (this.isTestOnCreate() != other.isTestOnCreate()) {
            return false;
        }
        if (this.isTestOnBorrow() != other.isTestOnBorrow()) {
            return false;
        }
        if (this.isTestOnReturn() != other.isTestOnReturn()) {
            return false;
        }
        if (this.isTestWhileIdle() != other.isTestWhileIdle()) {
            return false;
        }
        if (this.getTimeBetweenEvictionRunsMillis() != other.getTimeBetweenEvictionRunsMillis()) {
            return false;
        }
        if (this.isBlockWhenExhausted() != other.isBlockWhenExhausted()) {
            return false;
        }
        return this.getTimeOut() == other.getTimeOut();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HmilyRedisConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCluster() ? 79 : 97);
        result = result * 59 + (this.isSentinel() ? 79 : 97);
        String $clusterUrl = this.getClusterUrl();
        result = result * 59 + ($clusterUrl == null ? 43 : $clusterUrl.hashCode());
        String $sentinelUrl = this.getSentinelUrl();
        result = result * 59 + ($sentinelUrl == null ? 43 : $sentinelUrl.hashCode());
        String $masterName = this.getMasterName();
        result = result * 59 + ($masterName == null ? 43 : $masterName.hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        result = result * 59 + this.getPort();
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getMaxIdle();
        result = result * 59 + this.getMinIdle();
        long $maxWaitMillis = this.getMaxWaitMillis();
        result = result * 59 + (int)($maxWaitMillis >>> 32 ^ $maxWaitMillis);
        long $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + (int)($minEvictableIdleTimeMillis >>> 32 ^ $minEvictableIdleTimeMillis);
        long $softMinEvictableIdleTimeMillis = this.getSoftMinEvictableIdleTimeMillis();
        result = result * 59 + (int)($softMinEvictableIdleTimeMillis >>> 32 ^ $softMinEvictableIdleTimeMillis);
        result = result * 59 + this.getNumTestsPerEvictionRun();
        result = result * 59 + (this.isTestOnCreate() ? 79 : 97);
        result = result * 59 + (this.isTestOnBorrow() ? 79 : 97);
        result = result * 59 + (this.isTestOnReturn() ? 79 : 97);
        result = result * 59 + (this.isTestWhileIdle() ? 79 : 97);
        long $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + (int)($timeBetweenEvictionRunsMillis >>> 32 ^ $timeBetweenEvictionRunsMillis);
        result = result * 59 + (this.isBlockWhenExhausted() ? 79 : 97);
        result = result * 59 + this.getTimeOut();
        return result;
    }

    public String toString() {
        return "HmilyRedisConfig(cluster=" + this.isCluster() + ", sentinel=" + this.isSentinel() + ", clusterUrl=" + this.getClusterUrl() + ", sentinelUrl=" + this.getSentinelUrl() + ", masterName=" + this.getMasterName() + ", hostName=" + this.getHostName() + ", port=" + this.getPort() + ", password=" + this.getPassword() + ", maxTotal=" + this.getMaxTotal() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", maxWaitMillis=" + this.getMaxWaitMillis() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", softMinEvictableIdleTimeMillis=" + this.getSoftMinEvictableIdleTimeMillis() + ", numTestsPerEvictionRun=" + this.getNumTestsPerEvictionRun() + ", testOnCreate=" + this.isTestOnCreate() + ", testOnBorrow=" + this.isTestOnBorrow() + ", testOnReturn=" + this.isTestOnReturn() + ", testWhileIdle=" + this.isTestWhileIdle() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", blockWhenExhausted=" + this.isBlockWhenExhausted() + ", timeOut=" + this.getTimeOut() + ")";
    }
}

