/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.repository.database.sqlserver;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.dromara.hmily.config.api.entity.HmilyDatabaseConfig;
import org.dromara.hmily.repository.database.manager.AbstractHmilyDatabase;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="sqlserver")
public class SqlserverRepository
extends AbstractHmilyDatabase {
    private static final Logger log = LoggerFactory.getLogger(SqlserverRepository.class);
    private static final String SQL_FILE_PATH = "sqlserver/schema.sql";

    protected String hmilyTransactionLimitSql(int limit) {
        return "select trans_id, app_name, status, trans_type, retry, version from hmily_transaction_global  where update_time < ? and app_name = ?".replace("select", "select top " + limit);
    }

    protected String hmilyParticipantLimitSql(int limit) {
        return "select participant_id, participant_ref_id, trans_id, trans_type, status, app_name,role, retry, target_class, target_method, confirm_method, cancel_method, confirm_invocation, cancel_invocation, version from hmily_transaction_participant  where update_time < ? and app_name = ?  and trans_type = ? and status not in (4, 8) ".replace("select", "select top " + limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initScript(HmilyDatabaseConfig config) throws Exception {
        String jdbcUrl = StringUtils.replace((String)config.getUrl(), (String)"database=hmily", (String)"");
        Connection conn = DriverManager.getConnection(jdbcUrl, config.getUsername(), config.getPassword());
        ScriptRunner runner = new ScriptRunner(conn);
        String delimiter = "/";
        runner.setLogWriter(null);
        runner.setErrorLogWriter(null);
        runner.setAutoCommit(false);
        runner.setFullLineDelimiter(true);
        runner.setDelimiter("/");
        try {
            Reader read = Resources.getResourceAsReader((String)SQL_FILE_PATH);
            runner.runScript(read);
            conn.commit();
        }
        catch (Exception exception) {
        }
        finally {
            runner.closeConnection();
            conn.close();
        }
    }

    protected Object convertDataType(Object params) {
        if (params instanceof Integer) {
            return ((Number)params).longValue();
        }
        return params;
    }
}

