package org.example.common.thirty;

import org.example.common.enums.ShortLinkChannelEnum;
import org.example.common.thirty.entity.ShortLinkGenerateRequest;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @author liutao
 * @since 2024/3/8
 */
public interface ShortLinkService {

    String create(ShortLinkGenerateRequest request);
    String create(String longUrl);
    String create(String longUrl, Map<String, Object> query);
    ShortLinkChannelEnum type();

    default String getQueryString(Map<String, Object> query) {
        if (CollectionUtils.isEmpty(query)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        query.forEach((k,v) -> {
            builder.append(k).append("=").append(v).append("&");
        });
        return builder.deleteCharAt(builder.length() - 1).toString();
    }
}
