/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.config;

import cn.hutool.core.util.StrUtil;
import java.util.Collections;
import javax.annotation.Resource;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Resource
    private RedisProperties redisProperties;

    @Bean(name={"redissonClient"})
    @ConditionalOnProperty(name={"redis.arrange.type"}, havingValue="single")
    public RedissonClient singleRedissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress("redis://" + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setDatabase(this.redisProperties.getDatabase());
        if (!StrUtil.isEmpty((CharSequence)this.redisProperties.getPassword())) {
            singleServerConfig.setPassword(this.redisProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    @Bean(name={"redissonClient"})
    @ConditionalOnProperty(name={"redis.arrange.type"}, havingValue="cluster")
    public RedissonClient clusterRedissonClient() {
        Config config = new Config();
        ClusterServersConfig clusterServersConfig = config.useClusterServers();
        clusterServersConfig.setNodeAddresses(Collections.singletonList("redis://" + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()));
        if (!StrUtil.isEmpty((CharSequence)this.redisProperties.getPassword())) {
            clusterServersConfig.setPassword(this.redisProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }
}

