/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.thirty.impl;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.example.common.cache.RedisCacheService;
import org.example.common.enums.ShortLinkChannelEnum;
import org.example.common.exception.ApiCallException;
import org.example.common.exception.ShortUrlException;
import org.example.common.thirty.ShortLinkService;
import org.example.common.thirty.entity.ShortLinkGenerateRequest;
import org.example.common.util.HttpUtil;
import org.example.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxMaShortLinkServiceImpl
implements ShortLinkService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShortLinkServiceImpl.class);
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    private static final String GENERATE_URL_LINK = "https://api.weixin.qq.com/wxa/generate_urllink?access_token=%s";
    @Resource
    private RedisCacheService redisCacheService;

    @Override
    public String create(ShortLinkGenerateRequest request) {
        if (StringUtils.isEmpty(request.getLongUrl())) {
            throw new ShortUrlException("\u957f\u94fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String appInfo = request.getAppId() + "," + request.getSecret();
        String accessToken = this.redisCacheService.queryWithMutex("wx:ma:shortLink:token:", appInfo, String.class, this::getAccessToken, 7000L, TimeUnit.SECONDS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"path", (Object)request.getLongUrl());
        jsonObject.put((Object)"query", (Object)this.getQueryString(request.getQuery()));
        jsonObject.put((Object)"expire_type", (Object)1);
        jsonObject.put((Object)"expire_interval", (Object)30);
        JSONObject response = HttpUtil.post(String.format(GENERATE_URL_LINK, accessToken), jsonObject.toJSONString(new JSONWriter.Feature[0]), JSONObject.class);
        if (response.containsKey("url_link")) {
            return response.getString("url_link");
        }
        throw new ShortUrlException(String.format("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u77ed\u94fe\u751f\u6210\u5931\u8d25\uff1a%s,%s", response.getString("errcode"), response.getString("errmsg")));
    }

    @Override
    public String create(String longUrl) {
        return this.create(longUrl, null);
    }

    @Override
    public String create(String longUrl, Map<String, Object> query) {
        return null;
    }

    @Override
    public ShortLinkChannelEnum type() {
        return ShortLinkChannelEnum.wxMiniApp;
    }

    private String getAccessToken(String appInfo) {
        String[] arr = appInfo.split(",");
        JSONObject jsonObject = HttpUtil.get(String.format(ACCESS_TOKEN_URL, arr[0], arr[1]), JSONObject.class);
        if (jsonObject.containsKey("access_token")) {
            return jsonObject.getString("access_token");
        }
        throw new ApiCallException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u77ed\u94feapi\u8c03\u7528\u5931\u8d25");
    }
}

