/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.thirty.impl;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.URLEncodeUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.List;
import org.example.common.thirty.TycService;
import org.example.common.thirty.entity.CompanyBaseInfoData;
import org.example.common.thirty.entity.CompanyCustomerResult;
import org.example.common.thirty.entity.CompanyGroupMemberResult;
import org.example.common.thirty.entity.CompanyGroupResult;
import org.example.common.thirty.entity.CompanyProductResult;
import org.example.common.thirty.entity.CompanySearchData;
import org.example.common.thirty.entity.CompanySupplyResult;
import org.example.common.thirty.entity.TycCompanyInfoResponse;
import org.example.common.thirty.entity.TycCompanySearchResponse;
import org.example.common.util.HttpUtil;
import org.example.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"tyc.enable"}, havingValue="true")
public class TycServiceImpl
implements TycService {
    private static final Logger log = LoggerFactory.getLogger(TycServiceImpl.class);
    private static final String TYC_TOKEN_NAME = "Authorization";
    private static final String REASON = "reason";
    private static final String RESULT = "result";
    private static final String ITEMS = "items";
    private static final Integer MAX_PAGE_SIZE = 20;
    private static final String SUCCESS_REASON = "ok";
    private static final String ERROR_CODE_KEY = "error_code";
    @Value(value="${tyc.token}")
    private String token;

    @Override
    public List<CompanySearchData> search(String name, Integer pageNum) {
        try {
            String url = "https://open.api.tianyancha.com/services/open/search/2.0?word=%s&pageSize=%s&pageNum=%s";
            String responseBody = HttpUtil.get(String.format(url, name, MAX_PAGE_SIZE, pageNum), MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanySearchResponse<CompanySearchData> response = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanySearchResponse<CompanySearchData>>(){});
            if (response == null) {
                return Collections.emptyList();
            }
            String reason = response.getReason();
            if (SUCCESS_REASON.equals(reason)) {
                TycCompanySearchResponse.TycResult<CompanySearchData> result = response.getResult();
                if (result != null) {
                    return result.getItems();
                }
            } else {
                log.error("\u5929\u773c\u67e5\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)reason);
            }
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return Collections.emptyList();
    }

    @Override
    public CompanyBaseInfoData getCompanyBaseInfo(String keyword) {
        try {
            String url = "https://open.api.tianyancha.com/services/open/ic/baseinfo/normal?keyword=" + URLEncodeUtil.encode((String)keyword);
            String responseBody = HttpUtil.get(url, MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanyInfoResponse<CompanyBaseInfoData> resp = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanyInfoResponse<CompanyBaseInfoData>>(){});
            if (resp == null) {
                return null;
            }
            Integer errorCode = resp.getErrorCode();
            if (errorCode == 0) {
                return resp.getResult();
            }
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)resp.getReason());
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public CompanyProductResult getCompanyProduct(String keyword, Integer pageNum) {
        try {
            String url = "https://open.api.tianyancha.com/services/open/m/appbkInfo/2.0?pageSize=20&keyword=%s&pageNum=%s";
            String responseBody = HttpUtil.get(String.format(url, URLEncodeUtil.encode((String)keyword), pageNum), MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanyInfoResponse<CompanyProductResult> resp = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanyInfoResponse<CompanyProductResult>>(){});
            if (resp == null) {
                return null;
            }
            Integer errorCode = resp.getErrorCode();
            if (errorCode == 0) {
                return resp.getResult();
            }
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u4ea7\u54c1\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)resp.getReason());
        }
        catch (UtilException e) {
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u4ea7\u54c1\u4fe1\u606f\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public CompanyCustomerResult getCompanyCustomer(String keyword, Integer pageNum, Integer year) {
        String url = "https://open.api.tianyancha.com/services/open/m/customer/2.0?year=%s&pageSize=20&keyword=%s&pageNum=%s";
        try {
            String responseBody = HttpUtil.get(String.format(url, year, URLEncodeUtil.encode((String)keyword), pageNum), MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanyInfoResponse<CompanyCustomerResult> resp = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanyInfoResponse<CompanyCustomerResult>>(){});
            if (resp == null) {
                return null;
            }
            Integer errorCode = resp.getErrorCode();
            if (errorCode == 0) {
                return resp.getResult();
            }
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u5ba2\u6237\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)resp.getReason());
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u5ba2\u6237\u4fe1\u606f\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public CompanySupplyResult getCompanySupply(String keyword, Integer pageNum, Integer year) {
        String url = "https://open.api.tianyancha.com/services/open/m/supply/2.0?year=%s&pageSize=20&keyword=%s&pageNum=%s";
        try {
            String responseBody = HttpUtil.get(String.format(url, year, URLEncodeUtil.encode((String)keyword), pageNum), MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanyInfoResponse<CompanySupplyResult> resp = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanyInfoResponse<CompanySupplyResult>>(){});
            if (resp == null) {
                return null;
            }
            Integer errorCode = resp.getErrorCode();
            if (errorCode == 0) {
                return resp.getResult();
            }
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u4f9b\u5e94\u5546\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)resp.getReason());
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u4f9b\u5e94\u5546\u4fe1\u606f\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public CompanyGroupResult getCompanyGroup(String keyword) {
        String url = "https://open.api.tianyancha.com/services/open/group/base?keyword=%s";
        try {
            String responseBody = HttpUtil.get(String.format(url, URLEncodeUtil.encode((String)keyword)), MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanyInfoResponse<CompanyGroupResult> resp = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanyInfoResponse<CompanyGroupResult>>(){});
            if (resp == null) {
                return null;
            }
            Integer errorCode = resp.getErrorCode();
            if (errorCode == 0) {
                return resp.getResult();
            }
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u96c6\u56e2\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)resp.getReason());
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u96c6\u56e2\u4fe1\u606f\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public CompanyGroupMemberResult getCompanyGroupMember(Integer type, String uuid, Integer pageNum) {
        String url = "https://open.api.tianyancha.com/services/open/group/member?pageSize=20&type=%s&uuid=%s&pageNum=%s";
        try {
            String responseBody = HttpUtil.get(String.format(url, type, uuid, pageNum), MapUtil.of((Object)TYC_TOKEN_NAME, (Object)this.token));
            TycCompanyInfoResponse<CompanyGroupMemberResult> resp = JsonUtils.parseObject(responseBody, new TypeReference<TycCompanyInfoResponse<CompanyGroupMemberResult>>(){});
            if (resp == null) {
                return null;
            }
            Integer errorCode = resp.getErrorCode();
            if (errorCode == 0) {
                return resp.getResult();
            }
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u96c6\u56e2\u6210\u5458\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff1a{}", (Object)resp.getReason());
        }
        catch (Exception e) {
            log.error("\u5929\u773c\u67e5\u67e5\u8be2\u4f01\u4e1a\u96c6\u56e2\u6210\u5458\u4fe1\u606f\u63a5\u53e3\u62a5\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

