package org.example.common.id;

import cn.hutool.core.lang.Snowflake;
import com.github.yitter.contract.IdGeneratorOptions;
import com.github.yitter.idgen.YitIdHelper;
import lombok.extern.slf4j.Slf4j;
import org.example.common.enums.IdType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

/**
 * @author liutao
 * @since 2024/4/7
 */
@Slf4j
@Service
public class SnowFlakeIdGenerateServiceImpl implements IdGenerateService{


    @Value("${snowFlake.workerId:0}")
    private Short workerId;

    private Snowflake snowFlake;

    @PostConstruct
    public void init() {
        // 创建 IdGeneratorOptions 对象，可在构造函数中输入 WorkerId：
        IdGeneratorOptions options = new IdGeneratorOptions(workerId);
        YitIdHelper.setIdGenerator(options);
    }
    @Override
    public Long nextId() {
        return YitIdHelper.nextId();
    }

    @Override
    public String nextIdStr(IdType idType) {
        return nextIdStr() + idType.getType();
    }

    @Override
    public String nextIdStr() {
        return String.valueOf(nextId());
    }
}
