package org.example.common.mq;

import org.example.common.util.JsonUtils;

/**
 * @author liutao
 * @since 2024/5/30
 */
public interface MessageSenderService {
    default String getMessage(Object message) {
        if (message instanceof String) {
            return (String) message;
        }
        return JsonUtils.toJsonString( message);
    }

    boolean send(String topic, Object message);


    boolean sendOrderly(String topic, Object message, String hashKey);
}
