package org.example.common.thirty.impl;

import cn.hutool.core.map.MapUtil;
import lombok.extern.slf4j.Slf4j;
import org.example.common.thirty.IdentityCardService;
import org.example.common.thirty.entity.IdentityCardResponse;
import org.example.common.util.HttpUtil;
import org.example.common.util.JsonUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * @author liutao
 * @since 2024/3/21
 */
@Slf4j
@Service
public class IdentityCardServiceImpl implements IdentityCardService {

    private static final String URL = "https://zid.market.alicloudapi.com/idcard/VerifyIdcardv2?cardNo=%s&realName=%s";
    private static final String APP_CODE = "0411efcfca8d4d26898c68f48a974f26";
    @Override
    public boolean validateIdentityCard(String identityCard, String name) {
        try {
            // 去除空格
            name = StringUtils.trimAllWhitespace(name);
            identityCard = StringUtils.trimAllWhitespace(identityCard);
            // 调用http请求
            IdentityCardResponse response = HttpUtil.get(String.format(URL, identityCard, name), MapUtil.of("Authorization", "APPCODE " + APP_CODE), IdentityCardResponse.class);
            log.info("身份证验证响应:{}", JsonUtils.toJsonString( response));
            Integer errorCode = response.getErrorCode();
            if (errorCode != 0) {
                return false;
            }
            IdentityCardResponse.IdentityCardResult result = response.getResult();
            if (result == null) {
                return false;
            }
            return result.getSuccess();
        } catch (Exception e) {
            log.error("身份证校验异常{}", e.getMessage(), e);
            return true;
        }
    }
}
