/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.oapi;

import cn.hutool.core.util.ArrayUtil;
import com.lark.oapi.Client;
import com.lark.oapi.service.bitable.v1.model.AppTableRecord;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableRecordReqBody;
import com.lark.oapi.service.bitable.v1.model.BatchCreateAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableRecordReqBody;
import com.lark.oapi.service.bitable.v1.model.BatchDeleteAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.BatchUpdateAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.BatchUpdateAppTableRecordReqBody;
import com.lark.oapi.service.bitable.v1.model.BatchUpdateAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.DeleteAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.FilterInfo;
import com.lark.oapi.service.bitable.v1.model.SearchAppTableRecordReq;
import com.lark.oapi.service.bitable.v1.model.SearchAppTableRecordReqBody;
import com.lark.oapi.service.bitable.v1.model.SearchAppTableRecordResp;
import com.lark.oapi.service.bitable.v1.model.SearchAppTableRecordRespBody;
import java.util.Objects;
import org.example.common.oapi.BiTableService;

public class BiTableServiceImpl
implements BiTableService {
    private final Client client;

    @Override
    public BatchCreateAppTableRecordResp batchCreate(AppTableRecord[] fields, String tableId, String appToken) throws Exception {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return new BatchCreateAppTableRecordResp();
        }
        BatchCreateAppTableRecordReq req = BatchCreateAppTableRecordReq.newBuilder().batchCreateAppTableRecordReqBody(BatchCreateAppTableRecordReqBody.newBuilder().records(fields).build()).build();
        req.setAppToken(appToken);
        req.setTableId(tableId);
        return this.client.bitable().appTableRecord().batchCreate(req);
    }

    @Override
    public BatchUpdateAppTableRecordResp batchUpdate(AppTableRecord[] items, String tableId, String appToken) throws Exception {
        if (ArrayUtil.isEmpty((Object[])items)) {
            return new BatchUpdateAppTableRecordResp();
        }
        return this.client.bitable().appTableRecord().batchUpdate(BatchUpdateAppTableRecordReq.newBuilder().appToken(appToken).tableId(tableId).batchUpdateAppTableRecordReqBody(BatchUpdateAppTableRecordReqBody.newBuilder().records(items).build()).build());
    }

    @Override
    public AppTableRecord[] search(String tableId, String viewId, String appToken, FilterInfo filterInfo, String[] fields) throws Exception {
        SearchAppTableRecordReq req = SearchAppTableRecordReq.newBuilder().tableId(tableId).appToken(appToken).searchAppTableRecordReqBody(SearchAppTableRecordReqBody.newBuilder().viewId(viewId).filter(filterInfo).automaticFields(Boolean.valueOf(true)).fieldNames(fields).build()).build();
        SearchAppTableRecordResp resp = this.client.bitable().appTableRecord().search(req);
        SearchAppTableRecordRespBody recordRespBody = (SearchAppTableRecordRespBody)resp.getData();
        if (Objects.nonNull(recordRespBody)) {
            return recordRespBody.getItems();
        }
        return null;
    }

    @Override
    public DeleteAppTableRecordResp delete(String tableId, String recordId, String appToken) throws Exception {
        return this.client.bitable().appTableRecord().delete(DeleteAppTableRecordReq.newBuilder().appToken(appToken).tableId(tableId).recordId(recordId).build());
    }

    @Override
    public BatchDeleteAppTableRecordResp batchDelete(String tableId, String[] recordIds, String appToken) throws Exception {
        return this.client.bitable().appTableRecord().batchDelete(BatchDeleteAppTableRecordReq.newBuilder().appToken(appToken).tableId(tableId).batchDeleteAppTableRecordReqBody(BatchDeleteAppTableRecordReqBody.newBuilder().records(recordIds).build()).build());
    }

    public BiTableServiceImpl(Client client) {
        this.client = client;
    }
}

