/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.thirty.impl;

import cn.hutool.core.lang.Validator;
import cn.hutool.crypto.SecureUtil;
import com.aliyun.dytnsapi20200217.Client;
import com.aliyun.dytnsapi20200217.models.DescribePhoneNumberOperatorAttributeRequest;
import com.aliyun.dytnsapi20200217.models.DescribePhoneNumberOperatorAttributeResponse;
import com.aliyun.dytnsapi20200217.models.DescribePhoneNumberOperatorAttributeResponseBody;
import com.aliyun.teaopenapi.models.Config;
import javax.annotation.PostConstruct;
import org.example.common.enums.PhoneNumberOperatorAttributeCode;
import org.example.common.thirty.PhoneNumberOperatorAttributeService;
import org.example.common.thirty.entity.PhoneNumberAttribute;
import org.example.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"mobile.operator.attribute.enable"}, havingValue="true")
public class PhoneNumberOperatorAttributeServiceImpl
implements PhoneNumberOperatorAttributeService {
    private static final Logger log = LoggerFactory.getLogger(PhoneNumberOperatorAttributeServiceImpl.class);
    private Client client;
    @Value(value="${mobile.operator.attribute.accessKeyId}")
    private String accessKeyId;
    @Value(value="${mobile.operator.attribute.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${mobile.operator.attribute.authCode}")
    private String authCode;

    @PostConstruct
    public void init() throws Exception {
        Config config = new Config().setAccessKeyId(this.accessKeyId).setAccessKeySecret(this.accessKeySecret).setEndpoint("dytnsapi.aliyuncs.com");
        this.client = new Client(config);
    }

    @Override
    public PhoneNumberAttribute queryPhoneAttribute(String phone) {
        log.info("\u67e5\u8be2\u5f52\u5c5e\u5730\u624b\u673a\u53f7\uff1a {}", (Object)phone);
        if (!Validator.isMobile((CharSequence)phone)) {
            log.warn("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff1a {}", (Object)phone);
            return null;
        }
        DescribePhoneNumberOperatorAttributeRequest request = new DescribePhoneNumberOperatorAttributeRequest().setAuthCode(this.authCode).setInputNumber(SecureUtil.md5((String)phone)).setMask("MD5");
        try {
            DescribePhoneNumberOperatorAttributeResponse response = this.client.describePhoneNumberOperatorAttribute(request);
            DescribePhoneNumberOperatorAttributeResponseBody body = response.getBody();
            if (body.getCode().equals(PhoneNumberOperatorAttributeCode.OK.getCode())) {
                DescribePhoneNumberOperatorAttributeResponseBody.DescribePhoneNumberOperatorAttributeResponseBodyData data = body.getData();
                log.info("\u5f52\u5c5e\u5730\u4fe1\u606f\uff1a{}", (Object)JsonUtils.toJsonString(data));
                return new PhoneNumberAttribute(data.getBasicCarrier(), data.getCarrier(), data.getCity(), data.getIsNumberPortability(), data.getNumberSegment(), data.getProvince(), body.getCode());
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f52\u5c5e\u5730\u5931\u8d25\uff1a{}", (Object)phone);
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

