/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.trans;

import cn.hutool.core.lang.Dict;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.example.common.exception.ServiceException;
import org.example.common.trans.TranslationRequest;
import org.example.common.trans.TranslationResponse;
import org.example.common.trans.TranslationService;
import org.example.common.util.HttpUtil;
import org.example.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"translate.type"}, havingValue="xfyun")
public class XfYunTranslationServiceImpl
implements TranslationService {
    private static final Logger log = LoggerFactory.getLogger(XfYunTranslationServiceImpl.class);
    private static final String WEB_ITS_URL = "https://itrans.xfyun.cn/v2/its";
    @Value(value="${xf.appid:2f2c1455}")
    private String appId;
    @Value(value="${xf.apiKey:405796f886c313f8e1105fa563f6341d}")
    private String apiKey;
    @Value(value="${xf.apiSecret:ZjQ4MjM0ZDNmYTNhOGI2MzM3Y2UxOGNm}")
    private String apiSecret;

    @Override
    public String translate(TranslationRequest translationRequest) {
        try {
            String body;
            Map<String, String> header;
            TranslationResponse response;
            String content = translationRequest.getContent();
            String from = translationRequest.getFrom();
            String to = translationRequest.getTo();
            if (StringUtils.isBlank((CharSequence)content)) {
                throw new ServiceException("\u7ffb\u8bd1\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)from)) {
                from = "cn";
            }
            if (StringUtils.isBlank((CharSequence)to)) {
                to = "en";
            }
            if ((response = HttpUtil.post(WEB_ITS_URL, header = this.buildHttpHeader(body = this.buildHttpBody(from, to, content)), body, TranslationResponse.class)) != null) {
                log.info("\u3010ITS WebAPI \u63a5\u53e3\u8c03\u7528\u7ed3\u679c\u3011\n{}", (Object)JsonUtils.toJsonString(response));
                Integer code = response.getCode();
                if (code != 0) {
                    throw new ServiceException("\u7ffb\u8bd1\u5931\u8d25");
                }
                TranslationResponse.TransData data = response.getData();
                return data.getResult().getTransResult().getDst();
            }
            throw new ServiceException("\u7ffb\u8bd1\u5931\u8d25");
        }
        catch (Exception e) {
            throw new ServiceException("\u7ffb\u8bd1\u5931\u8d25");
        }
    }

    public Map<String, String> buildHttpHeader(String body) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>();
        URL url = new URL(WEB_ITS_URL);
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date dateD = new Date();
        String date = format.format(dateD);
        String digestBase64 = "SHA-256=" + XfYunTranslationServiceImpl.signBody(body);
        String builder = "host: " + url.getHost() + "\ndate: " + date + "\nPOST " + url.getPath() + " HTTP/1.1\ndigest: " + digestBase64;
        String sha = XfYunTranslationServiceImpl.hmacsign(builder, this.apiSecret);
        String authorization = String.format("api_key=\"%s\", algorithm=\"%s\", headers=\"%s\", signature=\"%s\"", this.apiKey, "hmac-sha256", "host date request-line digest", sha);
        log.info("\u3010ITS WebAPI authorization\u3011\n{}", (Object)authorization);
        header.put("Authorization", authorization);
        header.put("Content-Type", "application/json");
        header.put("Accept", "application/json,version=1.0");
        header.put("Host", url.getHost());
        header.put("Date", date);
        header.put("Digest", digestBase64);
        System.out.println("\u3010ITS WebAPI header\u3011\n" + header);
        return header;
    }

    private static String signBody(String body) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(body.getBytes(StandardCharsets.UTF_8));
            encodestr = Base64.getEncoder().encodeToString(messageDigest.digest());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return encodestr;
    }

    private static String hmacsign(String signature, String apiSecret) throws Exception {
        Charset charset = StandardCharsets.UTF_8;
        Mac mac = Mac.getInstance("hmacsha256");
        SecretKeySpec spec = new SecretKeySpec(apiSecret.getBytes(charset), "hmacsha256");
        mac.init(spec);
        byte[] hexDigits = mac.doFinal(signature.getBytes(charset));
        return Base64.getEncoder().encodeToString(hexDigits);
    }

    public String buildHttpBody(String from, String to, String content) {
        Dict body = new Dict();
        Dict business = new Dict();
        Dict common = new Dict();
        Dict data = new Dict();
        common.put("app_id", (Object)this.appId);
        business.put("from", (Object)from);
        business.put("to", (Object)to);
        byte[] textByte = content.getBytes(StandardCharsets.UTF_8);
        String textBase64 = Base64.getEncoder().encodeToString(textByte);
        data.put("text", (Object)textBase64);
        body.put("common", (Object)common);
        body.put("business", (Object)business);
        body.put("data", (Object)data);
        return JsonUtils.toJsonString(body);
    }
}

