/*
 * Decompiled with CFR 0.152.
 */
package org.example.common.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.AntPathMatcher;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String SEPARATOR = ",";

    public static String blankToDefault(String str, String defaultValue) {
        return StrUtil.blankToDefault((CharSequence)str, (String)defaultValue);
    }

    public static boolean isEmpty(String str) {
        return StrUtil.isEmpty((CharSequence)str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String trim(String str) {
        return StrUtil.trim((CharSequence)str);
    }

    public static String substring(String str, int start) {
        return StringUtils.substring(str, start, str.length());
    }

    public static String substring(String str, int start, int end) {
        return StrUtil.sub((CharSequence)str, (int)start, (int)end);
    }

    public static String format(String template, Object ... params) {
        return StrUtil.format((CharSequence)template, (Object[])params);
    }

    public static boolean isHttp(String link) {
        return Validator.isUrl((CharSequence)link);
    }

    public static Set<String> str2Set(String str, String sep) {
        return new HashSet<String>(StringUtils.str2List(str, sep, true, false));
    }

    public static List<String> str2List(String str, String sep, boolean filterBlank, boolean trim) {
        String[] split;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty(str)) {
            return list;
        }
        if (filterBlank && StringUtils.isBlank((CharSequence)str)) {
            return list;
        }
        for (String string : split = str.split(sep)) {
            if (filterBlank && StringUtils.isBlank((CharSequence)string)) continue;
            if (trim) {
                string = StringUtils.trim(string);
            }
            list.add(string);
        }
        return list;
    }

    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence ... searchCharSequences) {
        return StrUtil.containsAnyIgnoreCase((CharSequence)cs, (CharSequence[])searchCharSequences);
    }

    public static String toUnderScoreCase(String str) {
        return StrUtil.toUnderlineCase((CharSequence)str);
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        return StrUtil.equalsAnyIgnoreCase((CharSequence)str, (CharSequence[])strs);
    }

    public static String convertToCamelCase(String name) {
        return StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)name));
    }

    public static String toCamelCase(String s) {
        return StrUtil.toCamelCase((CharSequence)s);
    }

    public static boolean matches(String str, List<String> strs) {
        if (StringUtils.isEmpty(str) || CollUtil.isEmpty(strs)) {
            return false;
        }
        for (String pattern : strs) {
            if (!StringUtils.isMatch(pattern, str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(String pattern, String url) {
        AntPathMatcher matcher = new AntPathMatcher();
        return matcher.match(pattern, url);
    }

    public static String appendLeft(Number num, int size) {
        return StringUtils.appendLeft(num.toString(), size, '0');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String appendLeft(String s, int size, char c) {
        StringBuilder sb = new StringBuilder(size);
        if (s != null) {
            int len = s.length();
            if (s.length() > size) return s.substring(len - size, len);
            for (int i = size - len; i > 0; --i) {
                sb.append(c);
            }
            sb.append(s);
            return sb.toString();
        } else {
            for (int i = size; i > 0; --i) {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static List<String> splitList(String str) {
        return StringUtils.splitTo(str, Convert::toStr);
    }

    public static List<String> splitList(String str, String separator) {
        return StringUtils.splitTo(str, separator, Convert::toStr);
    }

    public static <T> List<T> splitTo(String str, Function<? super Object, T> mapper) {
        return StringUtils.splitTo(str, SEPARATOR, mapper);
    }

    public static <T> List<T> splitTo(String str, String separator, Function<? super Object, T> mapper) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new ArrayList(0);
        }
        return StrUtil.split((CharSequence)str, (CharSequence)separator).stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    private StringUtils() {
    }
}

