/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.sentinel.annotation.SentinelRestTemplate;
import org.springframework.cloud.alibaba.sentinel.custom.BlockClassRegistry;
import org.springframework.cloud.alibaba.sentinel.rest.SentinelClientHttpResponse;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ClassUtils;

public class SentinelProtectInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SentinelProtectInterceptor.class);
    private SentinelRestTemplate sentinelRestTemplate;

    public SentinelProtectInterceptor(SentinelRestTemplate sentinelRestTemplate) {
        this.sentinelRestTemplate = sentinelRestTemplate;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response;
        URI uri = request.getURI();
        String hostResource = uri.getScheme() + "://" + uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort());
        String hostWithPathResource = hostResource + uri.getPath();
        boolean entryWithPath = true;
        if (hostResource.equals(hostWithPathResource)) {
            entryWithPath = false;
        }
        Entry hostEntry = null;
        Entry hostWithPathEntry = null;
        try {
            ContextUtil.enter((String)hostWithPathResource);
            if (entryWithPath) {
                hostWithPathEntry = SphU.entry((String)hostWithPathResource);
            }
            hostEntry = SphU.entry((String)hostResource);
            response = execution.execute(request, body);
        }
        catch (Throwable e) {
            if (!BlockException.isBlockException((Throwable)e)) {
                Tracer.trace((Throwable)e);
                throw new IllegalStateException(e);
            }
            try {
                ClientHttpResponse clientHttpResponse = this.handleBlockException(request, body, execution, (BlockException)e);
                return clientHttpResponse;
            }
            catch (Exception ex) {
                if (ex instanceof IllegalStateException) {
                    throw (IllegalStateException)ex;
                }
                throw new IllegalStateException("sentinel handle BlockException error: " + ex.getMessage(), ex);
            }
        }
        finally {
            if (hostEntry != null) {
                hostEntry.exit();
            }
            if (hostWithPathEntry != null) {
                hostWithPathEntry.exit();
            }
            ContextUtil.exit();
        }
        return response;
    }

    private ClientHttpResponse handleBlockException(HttpRequest request, byte[] body, ClientHttpRequestExecution execution, BlockException ex) throws Exception {
        Object[] args = new Object[]{request, body, execution, ex};
        if (this.isDegradeFailure(ex)) {
            Method method = this.extractFallbackMethod(this.sentinelRestTemplate.fallback(), this.sentinelRestTemplate.fallbackClass());
            if (method != null) {
                return (ClientHttpResponse)method.invoke(null, args);
            }
            return new SentinelClientHttpResponse();
        }
        Method blockHandler = this.extractBlockHandlerMethod(this.sentinelRestTemplate.blockHandler(), this.sentinelRestTemplate.blockHandlerClass());
        if (blockHandler != null) {
            return (ClientHttpResponse)blockHandler.invoke(null, args);
        }
        return new SentinelClientHttpResponse();
    }

    private Method extractFallbackMethod(String fallback, Class<?> fallbackClass) {
        if (StringUtil.isBlank((String)fallback) || fallbackClass == Void.TYPE) {
            return null;
        }
        Method cachedMethod = BlockClassRegistry.lookupFallback(fallbackClass, fallback);
        Class[] args = new Class[]{HttpRequest.class, byte[].class, ClientHttpRequestExecution.class, BlockException.class};
        if (cachedMethod == null) {
            cachedMethod = ClassUtils.getStaticMethod(fallbackClass, (String)fallback, (Class[])args);
            if (cachedMethod != null) {
                if (!ClientHttpResponse.class.isAssignableFrom(cachedMethod.getReturnType())) {
                    throw new IllegalStateException(String.format("the return type of method [%s] in class [%s] is not ClientHttpResponse in degrade", cachedMethod.getName(), fallbackClass.getCanonicalName()));
                }
                BlockClassRegistry.updateFallbackFor(fallbackClass, fallback, cachedMethod);
            } else {
                throw new IllegalStateException(String.format("Cannot find method [%s] in class [%s] with parameters %s in degrade", fallback, fallbackClass.getCanonicalName(), Arrays.asList(args)));
            }
        }
        return cachedMethod;
    }

    private Method extractBlockHandlerMethod(String block, Class<?> blockClass) {
        if (StringUtil.isBlank((String)block) || blockClass == Void.TYPE) {
            return null;
        }
        Method cachedMethod = BlockClassRegistry.lookupBlockHandler(blockClass, block);
        Class[] args = new Class[]{HttpRequest.class, byte[].class, ClientHttpRequestExecution.class, BlockException.class};
        if (cachedMethod == null) {
            cachedMethod = ClassUtils.getStaticMethod(blockClass, (String)block, (Class[])args);
            if (cachedMethod != null) {
                if (!ClientHttpResponse.class.isAssignableFrom(cachedMethod.getReturnType())) {
                    throw new IllegalStateException(String.format("the return type of method [%s] in class [%s] is not ClientHttpResponse in flow control", cachedMethod.getName(), blockClass.getCanonicalName()));
                }
                BlockClassRegistry.updateBlockHandlerFor(blockClass, block, cachedMethod);
            } else {
                throw new IllegalStateException(String.format("Cannot find method [%s] in class [%s] with parameters %s in flow control", block, blockClass.getCanonicalName(), Arrays.asList(args)));
            }
        }
        return cachedMethod;
    }

    private boolean isDegradeFailure(BlockException ex) {
        return ex instanceof DegradeException;
    }
}

