/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.endpoint;

import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.cloud.alibaba.sentinel.SentinelProperties;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelDataSourceHandler;
import org.springframework.context.ApplicationContext;

public class SentinelEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    @Autowired
    private SentinelProperties sentinelProperties;
    @Autowired
    private SentinelDataSourceHandler dataSourceHandler;
    @Autowired
    private ApplicationContext applicationContext;

    public SentinelEndpoint() {
        super("sentinel");
    }

    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List flowRules = FlowRuleManager.getRules();
        List degradeRules = DegradeRuleManager.getRules();
        List systemRules = SystemRuleManager.getRules();
        List paramFlowRules = ParamFlowRuleManager.getRules();
        result.put("properties", this.sentinelProperties);
        result.put("FlowRules", flowRules);
        result.put("DegradeRules", degradeRules);
        result.put("SystemRules", systemRules);
        result.put("ParamFlowRule", paramFlowRules);
        result.put("datasources", new HashMap());
        for (String dataSourceBeanName : this.dataSourceHandler.getDataSourceBeanNameList()) {
            ReadableDataSource dataSource = (ReadableDataSource)this.applicationContext.getBean(dataSourceBeanName, ReadableDataSource.class);
            try {
                ((HashMap)result.get("datasources")).put(dataSourceBeanName, dataSource.loadConfig());
            }
            catch (Exception e) {
                ((HashMap)result.get("datasources")).put(dataSourceBeanName, "load error: " + e.getMessage());
            }
        }
        return result;
    }
}

