/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.context.acm;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.acm.AcmConfiguration;
import com.alibaba.cloud.context.acm.AliCloudAcmInitializer;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alicloud.context.AliCloudProperties;
import org.springframework.cloud.alicloud.context.acm.AcmIntegrationProperties;
import org.springframework.cloud.alicloud.context.acm.AcmProperties;
import org.springframework.cloud.alicloud.context.edas.EdasContextAutoConfiguration;
import org.springframework.cloud.alicloud.context.edas.EdasProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={AcmProperties.class})
@ConditionalOnClass(name={"org.springframework.cloud.alicloud.acm.AcmAutoConfiguration"})
@ImportAutoConfiguration(value={EdasContextAutoConfiguration.class})
public class AcmContextBootstrapConfiguration {
    @Autowired
    private AcmProperties acmProperties;
    @Autowired
    private EdasProperties edasProperties;
    @Autowired
    private AliCloudProperties aliCloudProperties;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void initAcmProperties() {
        AliCloudAcmInitializer.initialize((AliCloudConfiguration)this.aliCloudProperties, (EdasConfiguration)this.edasProperties, (AcmConfiguration)this.acmProperties);
    }

    @Bean
    public AcmIntegrationProperties acmIntegrationProperties() {
        AcmIntegrationProperties acmIntegrationProperties = new AcmIntegrationProperties();
        String applicationName = this.environment.getProperty("spring.application.name");
        String applicationGroup = this.environment.getProperty("spring.application.group");
        Assert.isTrue((!StringUtils.isEmpty((Object)applicationName) ? 1 : 0) != 0, (String)"'spring.application.name' must be configured in bootstrap.properties or bootstrap.yml/yaml...");
        acmIntegrationProperties.setApplicationName(applicationName);
        acmIntegrationProperties.setApplicationGroup(applicationGroup);
        acmIntegrationProperties.setActiveProfiles(this.environment.getActiveProfiles());
        acmIntegrationProperties.setAcmProperties(this.acmProperties);
        return acmIntegrationProperties;
    }
}

