/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.context.acm;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.alicloud.context.acm.AcmProperties;
import org.springframework.util.StringUtils;

public class AcmIntegrationProperties {
    private String applicationName;
    private String applicationGroup;
    private String[] activeProfiles = new String[0];
    private AcmProperties acmProperties;

    public String getApplicationConfigurationDataIdWithoutGroup() {
        return this.applicationName + "." + this.acmProperties.getFileExtension();
    }

    public List<String> getGroupConfigurationDataIds() {
        ArrayList<String> groupConfigurationDataIds = new ArrayList<String>();
        if (StringUtils.isEmpty((Object)this.applicationGroup)) {
            return groupConfigurationDataIds;
        }
        String[] parts = this.applicationGroup.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            StringBuilder subGroup = new StringBuilder(parts[0]);
            for (int j = 1; j <= i; ++j) {
                subGroup.append(".").append(parts[j]);
            }
            groupConfigurationDataIds.add(subGroup + ":application." + this.acmProperties.getFileExtension());
        }
        return groupConfigurationDataIds;
    }

    public List<String> getApplicationConfigurationDataIds() {
        ArrayList<String> applicationConfigurationDataIds = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)this.applicationGroup)) {
            applicationConfigurationDataIds.add(this.applicationGroup + ":" + this.applicationName + "." + this.acmProperties.getFileExtension());
            for (String profile : this.activeProfiles) {
                applicationConfigurationDataIds.add(this.applicationGroup + ":" + this.applicationName + "-" + profile + "." + this.acmProperties.getFileExtension());
            }
        }
        applicationConfigurationDataIds.add(this.applicationName + "." + this.acmProperties.getFileExtension());
        for (String profile : this.activeProfiles) {
            applicationConfigurationDataIds.add(this.applicationName + "-" + profile + "." + this.acmProperties.getFileExtension());
        }
        return applicationConfigurationDataIds;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setApplicationGroup(String applicationGroup) {
        this.applicationGroup = applicationGroup;
    }

    public void setActiveProfiles(String[] activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setAcmProperties(AcmProperties acmProperties) {
        this.acmProperties = acmProperties;
    }

    public AcmProperties getAcmProperties() {
        return this.acmProperties;
    }
}

