/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alicloud.context.oss;

import com.alibaba.cloud.context.AliCloudAuthorizationMode;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.alicloud.context.AliCloudContextAutoConfiguration;
import org.springframework.cloud.alicloud.context.AliCloudProperties;
import org.springframework.cloud.alicloud.context.oss.OssProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(name={"org.springframework.cloud.alicloud.oss.OssAutoConfiguration"})
@EnableConfigurationProperties(value={OssProperties.class})
@ImportAutoConfiguration(value={AliCloudContextAutoConfiguration.class})
public class OssContextAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public OSS ossClient(AliCloudProperties aliCloudProperties, OssProperties ossProperties) {
        if (ossProperties.getAuthorizationMode() == AliCloudAuthorizationMode.AK_SK) {
            Assert.isTrue((!StringUtils.isEmpty((Object)ossProperties.getEndpoint()) ? 1 : 0) != 0, (String)"Oss endpoint can't be empty.");
            Assert.isTrue((!StringUtils.isEmpty((Object)aliCloudProperties.getAccessKey()) ? 1 : 0) != 0, (String)"Access key can't be empty.");
            Assert.isTrue((!StringUtils.isEmpty((Object)aliCloudProperties.getSecretKey()) ? 1 : 0) != 0, (String)"Secret key can't be empty.");
            return new OSSClientBuilder().build(ossProperties.getEndpoint(), aliCloudProperties.getAccessKey(), aliCloudProperties.getSecretKey(), ossProperties.getConfig());
        }
        if (ossProperties.getAuthorizationMode() == AliCloudAuthorizationMode.STS) {
            Assert.isTrue((!StringUtils.isEmpty((Object)ossProperties.getEndpoint()) ? 1 : 0) != 0, (String)"Oss endpoint can't be empty.");
            Assert.isTrue((!StringUtils.isEmpty((Object)ossProperties.getSts().getAccessKey()) ? 1 : 0) != 0, (String)"Access key can't be empty.");
            Assert.isTrue((!StringUtils.isEmpty((Object)ossProperties.getSts().getSecretKey()) ? 1 : 0) != 0, (String)"Secret key can't be empty.");
            Assert.isTrue((!StringUtils.isEmpty((Object)ossProperties.getSts().getSecurityToken()) ? 1 : 0) != 0, (String)"Security Token can't be empty.");
            return new OSSClientBuilder().build(ossProperties.getEndpoint(), ossProperties.getSts().getAccessKey(), ossProperties.getSts().getSecretKey(), ossProperties.getSts().getSecurityToken(), ossProperties.getConfig());
        }
        throw new IllegalArgumentException("Unknown auth mode.");
    }
}

