/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.beans.ConstructorProperties;
import java.util.Set;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ZParams;

class JedisClusterZSetCommands
implements RedisZSetCommands {
    @NonNull
    private final JedisClusterConnection connection;

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            return this.connection.getCluster().zadd(key, JedisConverters.toTupleMap(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            return this.connection.getCluster().zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max));
            }
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return this.connection.getCluster().zrevrangeByScore(key, max, min);
            }
            return this.connection.getCluster().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREVRANGEBYSCOREWITHSCORES.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min));
            }
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZCOUNT.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.connection.getCluster().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZREMRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.connection.getCluster().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYSCORE.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return this.connection.getCluster().zrangeByScore(key, min, max);
            }
            return this.connection.getCluster().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range cannot be null for ZRANGEBYLEX.");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.toBytes("-"));
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.toBytes("+"));
        try {
            if (limit.isUnlimited()) {
                return this.connection.getCluster().zrangeByLex(key, min, max);
            }
            return this.connection.getCluster().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().zrangeByScore(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zrevrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().zrevrangeByScore(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return JedisConverters.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            return this.connection.getCluster().zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zremrangeByRank(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zunionstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            try {
                return this.connection.getCluster().zunionstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zinterstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            try {
                return this.connection.getCluster().zinterstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new IllegalArgumentException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(final byte[] key, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new ScanCursor<RedisZSetCommands.Tuple>(options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(long cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisClusterZSetCommands.this.connection.getCluster().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getStringCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            return this.connection.getCluster().zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE!");
        }
        try {
            return this.connection.getCluster().zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max), Long.valueOf(offset).intValue(), Long.valueOf(count).intValue());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    @ConstructorProperties(value={"connection"})
    public JedisClusterZSetCommands(@NonNull JedisClusterConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

