/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisSentinelConfiguration
implements RedisConfiguration,
RedisConfiguration.SentinelConfiguration {
    private static final String REDIS_SENTINEL_MASTER_CONFIG_PROPERTY = "spring.redis.sentinel.master";
    private static final String REDIS_SENTINEL_NODES_CONFIG_PROPERTY = "spring.redis.sentinel.nodes";
    private static final String REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY = "spring.redis.sentinel.password";
    @Nullable
    private NamedNode master;
    private Set<RedisNode> sentinels;
    private int database;
    @Nullable
    private String dataNodeUsername = null;
    private RedisPassword dataNodePassword = RedisPassword.none();
    private RedisPassword sentinelPassword = RedisPassword.none();

    public RedisSentinelConfiguration() {
        this((PropertySource<?>)new MapPropertySource("RedisSentinelConfiguration", Collections.emptyMap()));
    }

    public RedisSentinelConfiguration(String master, Set<String> sentinelHostAndPorts) {
        this((PropertySource<?>)new MapPropertySource("RedisSentinelConfiguration", RedisSentinelConfiguration.asMap(master, sentinelHostAndPorts)));
    }

    public RedisSentinelConfiguration(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null!");
        this.sentinels = new LinkedHashSet<RedisNode>();
        if (propertySource.containsProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY)) {
            this.setMaster(propertySource.getProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY).toString());
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY)) {
            this.appendSentinels(StringUtils.commaDelimitedListToSet((String)propertySource.getProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY).toString()));
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY)) {
            this.setSentinelPassword(propertySource.getProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY).toString());
        }
    }

    public void setSentinels(Iterable<RedisNode> sentinels) {
        Assert.notNull(sentinels, (String)"Cannot set sentinels to 'null'.");
        this.sentinels.clear();
        for (RedisNode sentinel : sentinels) {
            this.addSentinel(sentinel);
        }
    }

    @Override
    public Set<RedisNode> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void addSentinel(RedisNode sentinel) {
        Assert.notNull((Object)sentinel, (String)"Sentinel must not be 'null'.");
        this.sentinels.add(sentinel);
    }

    @Override
    public void setMaster(NamedNode master) {
        Assert.notNull((Object)master, (String)"Sentinel master node must not be 'null'.");
        this.master = master;
    }

    @Override
    public NamedNode getMaster() {
        return this.master;
    }

    public RedisSentinelConfiguration master(String master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration master(NamedNode master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration sentinel(RedisNode sentinel) {
        this.addSentinel(sentinel);
        return this;
    }

    public RedisSentinelConfiguration sentinel(String host, Integer port) {
        return this.sentinel(new RedisNode(host, port));
    }

    private void appendSentinels(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addSentinel(RedisNode.fromString(hostAndPort));
        }
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, () -> String.format("Invalid DB index '%s' (a positive index required)", index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.dataNodeUsername = username;
    }

    @Override
    @Nullable
    public String getUsername() {
        return this.dataNodeUsername;
    }

    @Override
    public RedisPassword getPassword() {
        return this.dataNodePassword;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null!");
        this.dataNodePassword = password;
    }

    @Override
    public void setSentinelPassword(RedisPassword sentinelPassword) {
        Assert.notNull((Object)sentinelPassword, (String)"SentinelPassword must not be null!");
        this.sentinelPassword = sentinelPassword;
    }

    @Override
    public RedisPassword getSentinelPassword() {
        return this.sentinelPassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisSentinelConfiguration)) {
            return false;
        }
        RedisSentinelConfiguration that = (RedisSentinelConfiguration)o;
        if (this.database != that.database) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.master, (Object)that.master)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.sentinels, that.sentinels)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.dataNodeUsername, (Object)that.dataNodeUsername)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.dataNodePassword, (Object)that.dataNodePassword)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.sentinelPassword, (Object)that.sentinelPassword);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.master);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinels);
        result = 31 * result + this.database;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.dataNodeUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.dataNodePassword);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sentinelPassword);
        return result;
    }

    private static Map<String, Object> asMap(String master, Set<String> sentinelHostAndPorts) {
        Assert.hasText((String)master, (String)"Master address must not be null or empty!");
        Assert.notNull(sentinelHostAndPorts, (String)"SentinelHostAndPorts must not be null!");
        Assert.noNullElements(sentinelHostAndPorts, (String)"ClusterHostAndPorts must not contain null elements!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY, master);
        map.put(REDIS_SENTINEL_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(sentinelHostAndPorts));
        return map;
    }
}

