/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.util;

import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class RedisAssertions {
    public static <T> T requireNonNull(@Nullable T target, String message, Object ... arguments) {
        return RedisAssertions.requireNonNull(target, () -> String.format(message, arguments));
    }

    public static <T> T requireNonNull(@Nullable T target, Supplier<String> message) {
        Assert.notNull(target, message);
        return target;
    }

    public static <T> T requireNonNull(@Nullable T target, RuntimeExceptionSupplier cause) {
        if (target == null) {
            throw (RuntimeException)cause.get();
        }
        return target;
    }

    public static <T> T requireState(@Nullable T target, String message, Object ... arguments) {
        return RedisAssertions.requireState(target, () -> String.format(message, arguments));
    }

    public static <T> T requireState(@Nullable T target, Supplier<String> message) {
        Assert.state((target != null ? 1 : 0) != 0, message);
        return target;
    }

    public static interface RuntimeExceptionSupplier
    extends Supplier<RuntimeException> {
    }
}

