/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.ClassUtils;

public abstract class AbstractJavaTypeMapper
implements BeanClassLoaderAware {
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    public static final String DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__ContentTypeId__";
    public static final String DEFAULT_KEY_CLASSID_FIELD_NAME = "__KeyTypeId__";
    private final Map<String, Class<?>> idClassMapping = new HashMap();
    private final Map<Class<?>, byte[]> classIdMapping = new HashMap();
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public String getClassIdFieldName() {
        return DEFAULT_CLASSID_FIELD_NAME;
    }

    public String getContentClassIdFieldName() {
        return DEFAULT_CONTENT_CLASSID_FIELD_NAME;
    }

    public String getKeyClassIdFieldName() {
        return DEFAULT_KEY_CLASSID_FIELD_NAME;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping.putAll(idClassMapping);
        this.createReverseMap();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void addHeader(Headers headers, String headerName, Class<?> clazz) {
        if (this.classIdMapping.containsKey(clazz)) {
            headers.add((Header)new RecordHeader(headerName, this.classIdMapping.get(clazz)));
        } else {
            headers.add((Header)new RecordHeader(headerName, clazz.getName().getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected String retrieveHeader(Headers headers, String headerName) {
        String classId = this.retrieveHeaderAsString(headers, headerName);
        if (classId == null) {
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + headerName + " in header");
        }
        return classId;
    }

    protected String retrieveHeaderAsString(Headers headers, String headerName) {
        Iterator headerValues = headers.headers(headerName).iterator();
        if (headerValues.hasNext()) {
            Header headerValue = (Header)headerValues.next();
            String classId = null;
            if (headerValue.value() != null) {
                classId = new String(headerValue.value(), StandardCharsets.UTF_8);
            }
            return classId;
        }
        return null;
    }

    private void createReverseMap() {
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            this.classIdMapping.put(clazz, id.getBytes(StandardCharsets.UTF_8));
        }
    }

    public Map<String, Class<?>> getIdClassMapping() {
        return Collections.unmodifiableMap(this.idClassMapping);
    }
}

